/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.managers.storage;

import com.google.common.base.Preconditions;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class RegionDatabaseUtils {
    private static final Logger log = Logger.getLogger(RegionDatabaseUtils.class.getCanonicalName());

    private RegionDatabaseUtils() {
    }

    public static void trySetFlagMap(ProtectedRegion region, Map<String, Object> flagData) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull(flagData);
        for (Flag<?> flag : DefaultFlag.getFlags()) {
            Object o2;
            if (flag == null) continue;
            Object o = flagData.get(flag.getName());
            if (o != null) {
                RegionDatabaseUtils.trySetFlag(region, flag, o);
            }
            if (flag.getRegionGroupFlag() == null || (o2 = flagData.get(flag.getRegionGroupFlag().getName())) == null) continue;
            RegionDatabaseUtils.trySetFlag(region, flag.getRegionGroupFlag(), o2);
        }
    }

    public static <T> boolean trySetFlag(ProtectedRegion region, Flag<T> flag, @Nullable Object value) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull(flag);
        T val = flag.unmarshal(value);
        if (val != null) {
            region.setFlag(flag, val);
            return true;
        }
        log.warning("Failed to parse flag '" + flag.getName() + "' with value '" + value + "'");
        return false;
    }

    public static void relinkParents(Map<String, ProtectedRegion> regions, Map<ProtectedRegion, String> parentSets) {
        Preconditions.checkNotNull(regions);
        Preconditions.checkNotNull(parentSets);
        for (Map.Entry<ProtectedRegion, String> entry : parentSets.entrySet()) {
            ProtectedRegion target = entry.getKey();
            ProtectedRegion parent = regions.get(entry.getValue());
            if (parent != null) {
                try {
                    target.setParent(parent);
                }
                catch (ProtectedRegion.CircularInheritanceException e) {
                    log.warning("Circular inheritance detected! Can't set the parent of '" + target + "' to parent '" + parent.getId() + "'");
                }
                continue;
            }
            log.warning("Unknown region parent: " + entry.getValue());
        }
    }
}

