/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session.handler;

import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.commands.CommandUtils;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ExitFlag
extends FlagValueChangeHandler<StateFlag.State> {
    private static final long MESSAGE_THRESHOLD = 2000L;
    private String storedMessage;
    private boolean exitViaTeleport = false;
    private long lastMessage;

    public ExitFlag(Session session) {
        super(session, DefaultFlag.EXIT);
    }

    private void update(LocalPlayer localPlayer, ApplicableRegionSet set, boolean allowed) {
        if (!allowed) {
            this.storedMessage = set.queryValue(localPlayer, DefaultFlag.EXIT_DENY_MESSAGE);
            this.exitViaTeleport = set.testState(localPlayer, DefaultFlag.EXIT_VIA_TELEPORT);
        }
    }

    private void sendMessage(Player player) {
        long now = System.currentTimeMillis();
        if (now - this.lastMessage > 2000L && this.storedMessage != null && !this.storedMessage.isEmpty()) {
            player.sendMessage(CommandUtils.replaceColorMacros(this.storedMessage));
            this.lastMessage = now;
        }
    }

    @Override
    protected void onInitialValue(Player player, ApplicableRegionSet set, StateFlag.State value) {
        this.update(this.getPlugin().wrapPlayer(player), set, StateFlag.test(value));
    }

    @Override
    protected boolean onSetValue(Player player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State currentValue, StateFlag.State lastValue, MoveType moveType) {
        Boolean override;
        if (this.getSession().getManager().hasBypass(player, from.getWorld())) {
            return true;
        }
        boolean lastAllowed = StateFlag.test(lastValue);
        boolean allowed = StateFlag.test(currentValue);
        LocalPlayer localPlayer = this.getPlugin().wrapPlayer(player);
        if (!(!allowed || lastAllowed || moveType.isTeleport() && this.exitViaTeleport || !moveType.isCancellable() || (override = toSet.queryValue(localPlayer, DefaultFlag.EXIT_OVERRIDE)) != null && override.booleanValue())) {
            this.sendMessage(player);
            return false;
        }
        this.update(localPlayer, toSet, allowed);
        return true;
    }

    @Override
    protected boolean onAbsentValue(Player player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State lastValue, MoveType moveType) {
        Boolean override;
        if (this.getSession().getManager().hasBypass(player, from.getWorld())) {
            return true;
        }
        boolean lastAllowed = StateFlag.test(lastValue);
        if (!(lastAllowed || !moveType.isCancellable() || (override = toSet.queryValue(this.getPlugin().wrapPlayer(player), DefaultFlag.EXIT_OVERRIDE)) != null && override.booleanValue())) {
            this.sendMessage(player);
            return false;
        }
        return true;
    }
}

