/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.protect;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.protect.IProtect;
import com.earth2me.essentials.protect.ProtectConfig;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import org.bukkit.plugin.Plugin;

public class EssentialsConnect {
    private static final Logger LOGGER = Logger.getLogger("Minecraft");
    private final IEssentials ess;
    private final IProtect protect;

    public EssentialsConnect(Plugin essPlugin, Plugin essProtect) {
        if (!essProtect.getDescription().getVersion().equals(essPlugin.getDescription().getVersion())) {
            LOGGER.log(Level.WARNING, I18n._((String)"versionMismatchAll", (Object[])new Object[0]));
        }
        this.ess = (IEssentials)essPlugin;
        this.protect = (IProtect)essProtect;
        ProtectReloader pr = new ProtectReloader();
        pr.reloadConfig();
        this.ess.addReloadListener((IConf)pr);
    }

    public IEssentials getEssentials() {
        return this.ess;
    }

    private class ProtectReloader
    implements IConf {
        private ProtectReloader() {
        }

        public void reloadConfig() {
            for (ProtectConfig protectConfig : ProtectConfig.values()) {
                if (protectConfig.isList()) {
                    EssentialsConnect.this.protect.getSettingsList().put(protectConfig, EssentialsConnect.this.ess.getSettings().getProtectList(protectConfig.getConfigName()));
                    continue;
                }
                if (protectConfig.isString()) {
                    EssentialsConnect.this.protect.getSettingsString().put(protectConfig, EssentialsConnect.this.ess.getSettings().getProtectString(protectConfig.getConfigName()));
                    continue;
                }
                EssentialsConnect.this.protect.getSettingsBoolean().put(protectConfig, EssentialsConnect.this.ess.getSettings().getProtectBoolean(protectConfig.getConfigName(), protectConfig.getDefaultValueBoolean()));
            }
        }
    }
}

