/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.protect;

import com.earth2me.essentials.protect.EmergencyListener;
import com.earth2me.essentials.protect.EssentialsConnect;
import com.earth2me.essentials.protect.EssentialsProtectBlockListener;
import com.earth2me.essentials.protect.EssentialsProtectEntityListener;
import com.earth2me.essentials.protect.EssentialsProtectWeatherListener;
import com.earth2me.essentials.protect.IProtect;
import com.earth2me.essentials.protect.ProtectConfig;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class EssentialsProtect
extends JavaPlugin
implements IProtect {
    private static final Logger LOGGER = Logger.getLogger("Minecraft");
    private final Map<ProtectConfig, Boolean> settingsBoolean = new EnumMap<ProtectConfig, Boolean>(ProtectConfig.class);
    private final Map<ProtectConfig, String> settingsString = new EnumMap<ProtectConfig, String>(ProtectConfig.class);
    private final Map<ProtectConfig, List<Integer>> settingsList = new EnumMap<ProtectConfig, List<Integer>>(ProtectConfig.class);
    private EssentialsConnect ess = null;

    public void onEnable() {
        PluginManager pm = this.getServer().getPluginManager();
        Plugin essPlugin = pm.getPlugin("Essentials");
        if (essPlugin == null || !essPlugin.isEnabled()) {
            this.enableEmergencyMode(pm);
            return;
        }
        this.ess = new EssentialsConnect(essPlugin, this);
        EssentialsProtectBlockListener blockListener = new EssentialsProtectBlockListener(this);
        pm.registerEvents((Listener)blockListener, (Plugin)this);
        EssentialsProtectEntityListener entityListener = new EssentialsProtectEntityListener(this);
        pm.registerEvents((Listener)entityListener, (Plugin)this);
        EssentialsProtectWeatherListener weatherListener = new EssentialsProtectWeatherListener(this);
        pm.registerEvents((Listener)weatherListener, (Plugin)this);
    }

    private void enableEmergencyMode(PluginManager pm) {
        EmergencyListener emListener = new EmergencyListener();
        pm.registerEvents((Listener)emListener, (Plugin)this);
        for (Player player : this.getServer().getOnlinePlayers()) {
            player.sendMessage("Essentials Protect is in emergency mode. Check your log for errors.");
        }
        LOGGER.log(Level.SEVERE, "Essentials not installed or failed to load. Essenials Protect is in emergency mode now.");
    }

    @Override
    public EssentialsConnect getEssentialsConnect() {
        return this.ess;
    }

    @Override
    public Map<ProtectConfig, Boolean> getSettingsBoolean() {
        return this.settingsBoolean;
    }

    @Override
    public Map<ProtectConfig, String> getSettingsString() {
        return this.settingsString;
    }

    @Override
    public Map<ProtectConfig, List<Integer>> getSettingsList() {
        return this.settingsList;
    }

    @Override
    public boolean getSettingBool(ProtectConfig protectConfig) {
        Boolean bool = this.settingsBoolean.get((Object)protectConfig);
        return bool == null ? protectConfig.getDefaultValueBoolean() : bool.booleanValue();
    }

    @Override
    public String getSettingString(ProtectConfig protectConfig) {
        String str = this.settingsString.get((Object)protectConfig);
        return str == null ? protectConfig.getDefaultValueString() : str;
    }
}

