/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.protect;

import com.earth2me.essentials.protect.IProtect;
import com.earth2me.essentials.protect.ProtectConfig;
import net.ess3.api.IEssentials;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;

public class EssentialsProtectBlockListener
implements Listener {
    private final IProtect prot;
    private final IEssentials ess;

    public EssentialsProtectBlockListener(IProtect parent) {
        this.prot = parent;
        this.ess = this.prot.getEssentialsConnect().getEssentials();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (event.getBlock().getType() == Material.OBSIDIAN || event.getBlock().getRelative(BlockFace.DOWN).getType() == Material.OBSIDIAN) {
            event.setCancelled(this.prot.getSettingBool(ProtectConfig.prevent_portal_creation));
            return;
        }
        if (event.getCause().equals((Object)BlockIgniteEvent.IgniteCause.SPREAD)) {
            event.setCancelled(this.prot.getSettingBool(ProtectConfig.prevent_fire_spread));
            return;
        }
        if (event.getCause().equals((Object)BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL)) {
            event.setCancelled(this.prot.getSettingBool(ProtectConfig.prevent_flint_fire));
            return;
        }
        if (event.getCause().equals((Object)BlockIgniteEvent.IgniteCause.LAVA)) {
            event.setCancelled(this.prot.getSettingBool(ProtectConfig.prevent_lava_fire_spread));
            return;
        }
        if (event.getCause().equals((Object)BlockIgniteEvent.IgniteCause.LIGHTNING)) {
            event.setCancelled(this.prot.getSettingBool(ProtectConfig.prevent_lightning_fire_spread));
            return;
        }
        if (event.getCause().equals((Object)BlockIgniteEvent.IgniteCause.FIREBALL)) {
            event.setCancelled(this.prot.getSettingBool(ProtectConfig.prevent_fireball_fire));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        Block block = event.getBlock();
        if (block.getType() == Material.WATER || block.getType() == Material.STATIONARY_WATER) {
            event.setCancelled(this.prot.getSettingBool(ProtectConfig.prevent_water_flow));
            return;
        }
        if (block.getType() == Material.LAVA || block.getType() == Material.STATIONARY_LAVA) {
            event.setCancelled(this.prot.getSettingBool(ProtectConfig.prevent_lava_flow));
            return;
        }
        if (block.getType() == Material.AIR) {
            event.setCancelled(this.prot.getSettingBool(ProtectConfig.prevent_water_bucket_flow));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        if (this.prot.getSettingBool(ProtectConfig.prevent_fire_spread)) {
            event.setCancelled(true);
        }
    }
}

