/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.libs.com.mojang.api.profiles;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.tehkode.libs.com.google.gson.Gson;
import ru.tehkode.libs.com.mojang.api.http.BasicHttpClient;
import ru.tehkode.libs.com.mojang.api.http.HttpBody;
import ru.tehkode.libs.com.mojang.api.http.HttpClient;
import ru.tehkode.libs.com.mojang.api.http.HttpHeader;
import ru.tehkode.libs.com.mojang.api.profiles.Profile;
import ru.tehkode.libs.com.mojang.api.profiles.ProfileRepository;

public class HttpProfileRepository
implements ProfileRepository {
    private static final int PROFILES_PER_REQUEST = 100;
    private static Gson gson = new Gson();
    private final String agent;
    private HttpClient client;

    public HttpProfileRepository(String agent) {
        this(agent, BasicHttpClient.getInstance());
    }

    public HttpProfileRepository(String agent, HttpClient client) {
        this.agent = agent;
        this.client = client;
    }

    @Override
    public Profile[] findProfilesByNames(String ... names) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        try {
            ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>();
            headers.add(new HttpHeader("Content-Type", "application/json"));
            int namesCount = names.length;
            int start = 0;
            int i = 0;
            do {
                int end;
                if ((end = 100 * (i + 1)) > namesCount) {
                    end = namesCount;
                }
                String[] namesBatch = Arrays.copyOfRange(names, start, end);
                HttpBody body = HttpProfileRepository.getHttpBody(namesBatch);
                Profile[] result = this.post(this.getProfilesUrl(), body, headers);
                profiles.addAll(Arrays.asList(result));
                start = end;
                ++i;
            } while (start < namesCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return profiles.toArray(new Profile[profiles.size()]);
    }

    private URL getProfilesUrl() throws MalformedURLException {
        return new URL("https://api.mojang.com/profiles/" + this.agent);
    }

    private Profile[] post(URL url, HttpBody body, List<HttpHeader> headers) throws IOException {
        String response = this.client.post(url, body, headers);
        return gson.fromJson(response, Profile[].class);
    }

    private static HttpBody getHttpBody(String ... namesBatch) {
        return new HttpBody(gson.toJson(namesBatch));
    }
}

