/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.ConfigurationSection;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;
import ru.tehkode.permissions.backends.PermissionBackend;
import ru.tehkode.permissions.backends.SchemaUpdate;
import ru.tehkode.permissions.backends.caching.CachingGroupData;
import ru.tehkode.permissions.backends.caching.CachingUserData;
import ru.tehkode.permissions.backends.file.FileConfig;
import ru.tehkode.permissions.backends.file.FileData;
import ru.tehkode.permissions.exceptions.PermissionBackendException;

public class FileBackend
extends PermissionBackend {
    public static final char PATH_SEPARATOR = '/';
    public FileConfig permissions;
    public File permissionsFile;
    private final Map<String, List<String>> worldInheritanceCache = new ConcurrentHashMap<String, List<String>>();
    private final Object lock = new Object();

    public FileBackend(PermissionManager manager, ConfigurationSection config) throws PermissionBackendException {
        super(manager, config);
        File baseDirectory;
        String baseDir;
        String permissionFilename = this.getConfig().getString("file");
        if (permissionFilename == null) {
            permissionFilename = "permissions.yml";
            this.getConfig().set("file", (Object)"permissions.yml");
        }
        if ((baseDir = manager.getConfiguration().getBasedir()).contains("\\") && !"\\".equals(File.separator)) {
            baseDir = baseDir.replace("\\", File.separator);
        }
        if (!(baseDirectory = new File(baseDir)).exists()) {
            baseDirectory.mkdirs();
        }
        this.permissionsFile = new File(baseDir, permissionFilename);
        this.addSchemaUpdate(new SchemaUpdate(1){

            @Override
            public void performUpdate() {
                ConfigurationSection groupSection;
                ConfigurationSection userSection = FileBackend.this.permissions.getConfigurationSection("users");
                if (userSection != null) {
                    for (Map.Entry e : userSection.getValues(false).entrySet()) {
                        if (!(e.getValue() instanceof ConfigurationSection)) continue;
                        this.allWorlds((ConfigurationSection)e.getValue());
                    }
                }
                if ((groupSection = FileBackend.this.permissions.getConfigurationSection("groups")) != null) {
                    for (Map.Entry e : groupSection.getValues(false).entrySet()) {
                        if (!(e.getValue() instanceof ConfigurationSection)) continue;
                        this.allWorlds((ConfigurationSection)e.getValue());
                    }
                }
            }

            private void allWorlds(ConfigurationSection section) {
                this.singleWorld(section);
                ConfigurationSection worldSection = section.getConfigurationSection("worlds");
                if (worldSection != null) {
                    for (Map.Entry e : worldSection.getValues(false).entrySet()) {
                        if (!(e.getValue() instanceof ConfigurationSection)) continue;
                        this.singleWorld((ConfigurationSection)e.getValue());
                    }
                }
            }

            private void singleWorld(ConfigurationSection section) {
                if (section.isSet("prefix")) {
                    section.set(FileBackend.buildPath("options", "prefix"), section.get("prefix"));
                    section.set("prefix", null);
                }
                if (section.isSet("suffix")) {
                    section.set(FileBackend.buildPath("options", "suffix"), section.get("suffix"));
                    section.set("suffix", null);
                }
                if (section.isSet("default")) {
                    section.set(FileBackend.buildPath("options", "default"), section.get("default"));
                    section.set("default", null);
                }
            }
        });
        this.reload();
        this.performSchemaUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSchemaVersion() {
        Object object = this.lock;
        synchronized (object) {
            return this.permissions.getInt("schema-version", -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setSchemaVersion(int version) {
        Object object = this.lock;
        synchronized (object) {
            this.permissions.set("schema-version", version);
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getWorldInheritance(String world) {
        if (world != null && !world.isEmpty()) {
            List<String> parentWorlds = this.worldInheritanceCache.get(world);
            if (parentWorlds == null) {
                Object object = this.lock;
                synchronized (object) {
                    parentWorlds = this.permissions.getStringList(FileBackend.buildPath("worlds", world, "inheritance"));
                    if (parentWorlds != null) {
                        parentWorlds = Collections.unmodifiableList(parentWorlds);
                        this.worldInheritanceCache.put(world, parentWorlds);
                        return parentWorlds;
                    }
                }
            } else {
                return parentWorlds;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> getAllWorldInheritance() {
        Object object = this.lock;
        synchronized (object) {
            ConfigurationSection worldsSection = this.permissions.getConfigurationSection("worlds");
            if (worldsSection == null) {
                return Collections.emptyMap();
            }
            HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
            for (String world : worldsSection.getKeys(false)) {
                ret.put(world, this.getWorldInheritance(world));
            }
            return Collections.unmodifiableMap(ret);
        }
    }

    @Override
    public void setWorldInheritance(final String world, List<String> rawParentWorlds) {
        if (world == null || world.isEmpty()) {
            return;
        }
        final ArrayList<String> parentWorlds = new ArrayList<String>(rawParentWorlds);
        this.worldInheritanceCache.put(world, parentWorlds);
        this.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = FileBackend.this.lock;
                synchronized (object) {
                    FileBackend.this.permissions.set(FileBackend.buildPath("worlds", world, "inheritance"), parentWorlds);
                    FileBackend.this.save();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionsUserData getUserData(String userName) {
        Object object = this.lock;
        synchronized (object) {
            CachingUserData data = new CachingUserData(new FileData("users", userName, this.permissions, "group"), this.getExecutor(), this.lock);
            data.load();
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionsGroupData getGroupData(String groupName) {
        Object object = this.lock;
        synchronized (object) {
            CachingGroupData data = new CachingGroupData(new FileData("groups", groupName, this.permissions, "inheritance"), this.getExecutor(), this.lock);
            data.load();
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUser(String userName) {
        Object object = this.lock;
        synchronized (object) {
            return this.permissions.isConfigurationSection(FileBackend.buildPath("users", userName.toLowerCase()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGroup(String group) {
        Object object = this.lock;
        synchronized (object) {
            if (this.permissions.isConfigurationSection(FileBackend.buildPath("groups", group))) {
                return true;
            }
            ConfigurationSection userSection = this.permissions.getConfigurationSection("groups");
            if (userSection != null) {
                for (String name : userSection.getKeys(false)) {
                    if (!group.equalsIgnoreCase(name)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getUserIdentifiers() {
        Object object = this.lock;
        synchronized (object) {
            ConfigurationSection users = this.permissions.getConfigurationSection("users");
            return users != null ? users.getKeys(false) : Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getUserNames() {
        Object object = this.lock;
        synchronized (object) {
            ConfigurationSection users = this.permissions.getConfigurationSection("users");
            if (users == null) {
                return Collections.emptySet();
            }
            HashSet<String> userNames = new HashSet<String>();
            for (Map.Entry entry : users.getValues(false).entrySet()) {
                if (!(entry.getValue() instanceof ConfigurationSection)) continue;
                ConfigurationSection userSection = (ConfigurationSection)entry.getValue();
                String name = userSection.getString(FileBackend.buildPath("options", "name"));
                if (name == null) continue;
                userNames.add(name);
            }
            return Collections.unmodifiableSet(userNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getGroupNames() {
        Object object = this.lock;
        synchronized (object) {
            ConfigurationSection groups = this.permissions.getConfigurationSection("groups");
            return groups != null ? groups.getKeys(false) : Collections.emptySet();
        }
    }

    public static String buildPath(String ... path) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        char separator = '/';
        for (String node : path) {
            if (node.isEmpty()) continue;
            if (!first) {
                builder.append(separator);
            }
            builder.append(node);
            first = false;
        }
        return builder.toString();
    }

    @Override
    public void reload() throws PermissionBackendException {
        FileConfig newPermissions = new FileConfig(this.permissionsFile, new Object(), "users");
        newPermissions.options().pathSeparator('/');
        try {
            newPermissions.load();
            this.getLogger().info("Permissions file successfully reloaded");
            this.worldInheritanceCache.clear();
            this.permissions = newPermissions;
        }
        catch (FileNotFoundException e) {
            if (this.permissions == null) {
                this.worldInheritanceCache.clear();
                this.permissions = newPermissions;
                this.initNewConfiguration();
            }
        }
        catch (Throwable e) {
            throw new PermissionBackendException("Error loading permissions file!", e);
        }
    }

    private void initNewConfiguration() throws PermissionBackendException {
        if (!this.permissionsFile.exists()) {
            try {
                this.permissionsFile.createNewFile();
                this.permissions.set("groups/default/options/default", true);
                LinkedList<String> defaultPermissions = new LinkedList<String>();
                defaultPermissions.add("modifyworld.*");
                this.permissions.set("groups/default/permissions", defaultPermissions);
                this.permissions.set("schema-version", this.getLatestSchemaVersion());
                this.save();
            }
            catch (IOException e) {
                throw new PermissionBackendException(e);
            }
        }
    }

    @Override
    public void loadFrom(PermissionBackend backend) {
        this.setPersistent(false);
        try {
            super.loadFrom(backend);
        }
        finally {
            this.setPersistent(true);
        }
        this.save();
    }

    @Override
    public void setPersistent(boolean persistent) {
        super.setPersistent(persistent);
        this.permissions.setSaveSuppressed(!persistent);
        if (persistent) {
            this.save();
        }
    }

    @Override
    public void writeContents(Writer writer) throws IOException {
        writer.write(this.permissions.saveToString());
    }

    public void save() {
        try {
            this.permissions.save();
        }
        catch (IOException e) {
            this.getManager().getLogger().severe("Error while saving permissions file: " + e.getMessage());
        }
    }
}

