/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.tehkode.utils.Interval;

public class DateUtils {
    protected static final Pattern INTERVAL_PATTERN = Pattern.compile("((?:\\d+)|(?:\\d+\\.\\d+))\\s*(second|minute|hour|day|week|month|year|s|m|h|d|w)", 2);

    public static int parseInterval(String arg) {
        if (arg.matches("^\\d+$")) {
            return Integer.parseInt(arg);
        }
        Matcher match = INTERVAL_PATTERN.matcher(arg);
        int interval = 0;
        while (match.find()) {
            interval += Math.round(Float.parseFloat(match.group(1)) * (float)DateUtils.getSecondsIn(match.group(2)));
        }
        return interval;
    }

    public static int getSecondsIn(String type) {
        type = type.toLowerCase();
        return Interval.byLabel(type).value();
    }
}

