/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag;

import java.util.ArrayList;
import java.util.List;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.modules.CommandModule;
import me.minebuilders.clearlag.modules.Module;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class CommandListener
implements CommandExecutor,
Module {
    private List<CommandModule> cmds = new ArrayList<CommandModule>();

    public boolean onCommand(CommandSender s, Command command, String label, String[] args) {
        if (args.length == 0 || this.getCmd(args[0]) == null) {
            List<CommandModule> cmds = this.getUserCmds(s);
            if (cmds.size() == 0) {
                s.sendMessage(ChatColor.RED + "You do not have permission to use this command!");
                return false;
            }
            s.sendMessage(ChatColor.DARK_AQUA + "-------------(" + ChatColor.AQUA + ChatColor.BOLD + "Your Clearlag Commands" + ChatColor.DARK_AQUA + ")-------------");
            for (CommandModule cmd : cmds) {
                s.sendMessage(ChatColor.DARK_RED + "  - " + cmd.sendHelpLine());
            }
            s.sendMessage(ChatColor.DARK_AQUA + "----------------------------------------------------");
        } else {
            this.getCmd(args[0]).processCmd(Clearlag.getInstance(), s, args);
        }
        return true;
    }

    public void addCmd(CommandModule cmd) {
        this.cmds.add(cmd);
    }

    private CommandModule getCmd(String s) {
        for (CommandModule cmd : this.cmds) {
            if (!cmd.cmdName.equalsIgnoreCase(s)) continue;
            return cmd;
        }
        return null;
    }

    public List<CommandModule> getUserCmds(CommandSender p) {
        ArrayList<CommandModule> mod = new ArrayList<CommandModule>();
        for (CommandModule cmd : this.cmds) {
            if (!p.hasPermission("lagg." + cmd.cmdName)) continue;
            mod.add(cmd);
        }
        return mod;
    }

    @Override
    public void load() {
        Clearlag.getInstance().getCommand("lagg").setExecutor((CommandExecutor)this);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

