/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import me.minebuilders.clearlag.modules.Module;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class Util {
    private static final Logger log = Logger.getLogger("Minecraft");

    public static void log(String m) {
        log.info("[ClearLag] " + m);
    }

    public static void warning(String m) {
        log.warning("[ClearLag] " + m);
    }

    public static void msg(String m, CommandSender s) {
        s.sendMessage(Util.color("&6[&aClearLag&6] &a" + m));
    }

    public static void scm(String m, CommandSender s) {
        s.sendMessage(Util.color(m));
    }

    public static String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static List<EntityType> getEntityTypes(List<String> s) {
        ArrayList<EntityType> types = new ArrayList<EntityType>();
        for (String st : s) {
            EntityType t = Util.getEntityTypeFromString(st);
            if (t != null) {
                types.add(t);
                continue;
            }
            Util.warning(String.valueOf(st) + " is NOT a valid Entity!");
        }
        return types;
    }

    public static EntityType getEntityTypeFromString(String s) {
        EntityType et = EntityType.fromName((String)s);
        if (et != null) {
            return et;
        }
        s = s.replace("_", "").replace(" ", "");
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            EntityType e = entityTypeArray[n2];
            if (e != null && ((name = e.name().replace("_", "")).contains(s) || name.equalsIgnoreCase(s) || name.startsWith(s))) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static Module[] getFieldInstances(Class<?> clazz, Object bd) {
        ArrayList<Module> objects = new ArrayList<Module>();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                objects.add((Module)f.get(bd));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return objects.toArray(new Module[objects.size()]);
    }

    public static Module[] nullifyFieldInstances(Class<?> clazz, Object bd) {
        ArrayList objects = new ArrayList();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                f.setAccessible(true);
                f.set(bd, null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return objects.toArray(new Module[objects.size()]);
    }

    public static int removeEntitys(List<Entity> e) {
        int i = 0;
        for (Entity en : e) {
            en.remove();
            ++i;
        }
        return i;
    }

    public static boolean isClass(String clazz) {
        try {
            Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static String getBukkitVersion() {
        String[] v = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3].split("-")[0].split("_");
        return String.valueOf(v[0].replace("v", "")) + "." + v[1];
    }

    public static boolean isInt(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static Date parseTime(String time) {
        try {
            String[] frag = time.split("-");
            if (frag.length < 2) {
                return new Date();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return dateFormat.parse(String.valueOf(frag[0]) + "-" + frag[1] + "-" + frag[2]);
        }
        catch (Exception e) {
            return new Date();
        }
    }
}

