/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.commands;

import me.minebuilders.clearlag.Config;
import me.minebuilders.clearlag.Modules;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.modules.CommandModule;
import me.minebuilders.clearlag.modules.ReloadableModule;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Hopper;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Item;
import org.bukkit.entity.Monster;
import org.bukkit.inventory.ItemStack;

public class CheckCmd
extends CommandModule
implements ReloadableModule {
    private boolean monster;
    private boolean animals;
    private boolean creature;

    public CheckCmd() {
        this.forcePlayer = true;
        this.cmdName = "check";
        this.argLength = 1;
        this.usage = "(Counts entities in your worlds)";
    }

    @Override
    public void run() {
        Configuration config = Config.getConfig();
        int removed1 = 0;
        int removed = 0;
        int chunks = 0;
        int spawners = 0;
        int activehoppers = 0;
        int inactivehoppers = 0;
        for (World w : Bukkit.getServer().getWorlds()) {
            if (config.getStringList("check.world-filter").contains(w.getName())) continue;
            Chunk[] chunkArray = w.getLoadedChunks();
            int n = chunkArray.length;
            int n2 = 0;
            while (n2 < n) {
                Chunk c = chunkArray[n2];
                BlockState[] blockStateArray = c.getTileEntities();
                int n3 = blockStateArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    BlockState bt = blockStateArray[n4];
                    if (bt instanceof CreatureSpawner) {
                        ++spawners;
                    } else if (bt instanceof Hopper) {
                        if (!this.isHopperEmpty((Hopper)bt)) {
                            ++activehoppers;
                        } else {
                            ++inactivehoppers;
                        }
                    }
                    ++n4;
                }
                blockStateArray = c.getEntities();
                n3 = blockStateArray.length;
                n4 = 0;
                while (n4 < n3) {
                    BlockState e = blockStateArray[n4];
                    if (e instanceof Monster && this.monster) {
                        ++removed;
                    } else if (e instanceof Animals && this.animals) {
                        ++removed;
                    } else if (e instanceof Creature && this.creature) {
                        ++removed;
                    } else if (e instanceof Item) {
                        ++removed1;
                    }
                    ++n4;
                }
                ++chunks;
                ++n2;
            }
        }
        Util.scm("&4*&3&m                          &8(&a&lServer Status&8)&3&m                           &4*", this.sender);
        this.sender.sendMessage(ChatColor.DARK_AQUA + "   Items on the ground: " + ChatColor.AQUA + removed1);
        this.sender.sendMessage(ChatColor.DARK_AQUA + "   Mobs alive: " + ChatColor.AQUA + removed);
        this.sender.sendMessage(ChatColor.DARK_AQUA + "   Chunks loaded: " + ChatColor.AQUA + chunks);
        this.sender.sendMessage(ChatColor.DARK_AQUA + "   Active hoppers: " + ChatColor.AQUA + activehoppers);
        this.sender.sendMessage(ChatColor.DARK_AQUA + "   Idle hoppers: " + ChatColor.AQUA + inactivehoppers);
        this.sender.sendMessage(ChatColor.DARK_AQUA + "   Active mob spawners: " + ChatColor.AQUA + spawners);
        this.sender.sendMessage(ChatColor.DARK_AQUA + "   Current TPS: " + ChatColor.AQUA + Modules.TPSTask.getStringTPS());
        this.sender.sendMessage(ChatColor.DARK_AQUA + "   Players online: " + ChatColor.AQUA + Bukkit.getServer().getOnlinePlayers().size());
        Util.scm("&4*&3&m                                                                             &4*", this.sender);
    }

    private boolean isHopperEmpty(Hopper hop) {
        ItemStack[] itemStackArray = hop.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack it = itemStackArray[n2];
            if (it != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void load() {
        super.load();
        this.reload();
    }

    @Override
    public void reload() {
        this.monster = Config.getConfig().getBoolean("check.mobs.monster");
        this.animals = Config.getConfig().getBoolean("check.mobs.monster");
        this.creature = Config.getConfig().getBoolean("check.mobs.monster");
    }
}

