/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.configupdater;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.minebuilders.clearlag.configupdater.configvalues.ConfigComment;
import me.minebuilders.clearlag.configupdater.configvalues.ConfigValue;

public class ConfigSection {
    private String key;
    private List<ConfigValue> body = new ArrayList<ConfigValue>();

    public boolean hasKey() {
        return this.key != null;
    }

    public void setKey(String key) {
        this.key = key;
        this.body.add(new ConfigComment(key));
    }

    public String getKey() {
        return this.key;
    }

    public void addConfigValue(ConfigValue cv) {
        this.body.add(cv);
    }

    public List<ConfigValue> getBody() {
        return this.body;
    }

    public void merge(ConfigSection cs) {
        for (ConfigValue cv : cs.getBody()) {
            for (ConfigValue cv2 : this.body) {
                if (!cv.equals(cv2)) continue;
                cv2.merge(cv);
            }
        }
    }

    public void writeToFile(BufferedWriter writer) throws IOException {
        for (ConfigValue s : this.body) {
            s.writeToFile(writer);
            writer.newLine();
        }
    }

    public String toString() {
        return this.key;
    }

    public boolean equals(Object ob) {
        return this.key.equals(ob.toString());
    }
}

