/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.listeners;

import java.util.ArrayList;
import me.minebuilders.clearlag.Config;
import me.minebuilders.clearlag.modules.EventModule;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;

public class ChunkEntityLimiterListener
extends EventModule {
    private int limit;

    public Entity[] filter(Entity[] e) {
        ArrayList<Entity> ed = new ArrayList<Entity>();
        Entity[] entityArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            Entity es = entityArray[n2];
            if (!(es instanceof Player)) {
                ed.add(es);
            }
            ++n2;
        }
        return ed.toArray(new Entity[ed.size()]);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onChunkLoad(ChunkLoadEvent event) {
        Entity[] ents = this.filter(event.getChunk().getEntities());
        if (ents.length > this.limit) {
            this.trim(ents);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onSpawn(CreatureSpawnEvent event) {
        Entity[] ents = this.filter(event.getEntity().getLocation().getChunk().getEntities());
        if (ents.length > this.limit) {
            this.trim(ents);
        }
    }

    public void trim(Entity[] es) {
        int id = es.length - this.limit;
        int i = 0;
        while (i < id) {
            es[i].remove();
            ++i;
        }
    }

    public int countChunks() {
        int size = 0;
        for (World w : Bukkit.getWorlds()) {
            size += w.getLoadedChunks().length;
        }
        return size;
    }

    @Override
    public boolean isEnabled() {
        return Config.getConfig().getBoolean("chunk-entity-limiter.enabled");
    }

    @Override
    public void setValues() {
        this.limit = Config.getConfig().getInt("chunk-entity-limiter.limit") + 1;
    }
}

