/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.listeners;

import me.minebuilders.clearlag.Config;
import me.minebuilders.clearlag.modules.EventModule;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.world.ChunkLoadEvent;

public class ChunkLimiterListener
extends EventModule {
    private int limit;
    private boolean createnew;

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!this.createnew && event.isNewChunk() || this.countChunks() >= this.limit) {
            event.getChunk().unload(false);
            Chunk[] chunkArray = event.getWorld().getLoadedChunks();
            int n = chunkArray.length;
            int n2 = 0;
            while (n2 < n) {
                Chunk c = chunkArray[n2];
                c.unload(true, true);
                ++n2;
            }
        }
    }

    public int countChunks() {
        int size = 0;
        for (World w : Bukkit.getWorlds()) {
            size += w.getLoadedChunks().length;
        }
        return size;
    }

    @Override
    public boolean isEnabled() {
        return Config.getConfig().getBoolean("chunk-limiter.enabled");
    }

    @Override
    public void setValues() {
        this.limit = Config.getConfig().getInt("chunk-limiter.limit");
        this.createnew = Config.getConfig().getBoolean("chunk-limiter.create-new-chunks");
    }
}

