/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.listeners;

import java.util.HashMap;
import me.minebuilders.clearlag.Config;
import me.minebuilders.clearlag.modules.EventModule;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ChunkOverloadListener
extends EventModule {
    public HashMap<String, Long> players;
    private long time;
    private boolean modifyonlyfly;

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlockX() >> 4 == event.getTo().getBlockX() >> 4 && event.getFrom().getBlockZ() >> 4 == event.getTo().getBlockZ() >> 4) {
            return;
        }
        if (this.modifyonlyfly && !event.getPlayer().isFlying()) {
            return;
        }
        if (this.players.get(event.getPlayer().getName()) > System.currentTimeMillis()) {
            Location l = event.getFrom();
            event.setTo(new Location(l.getWorld(), (double)l.getBlockX() + 0.5, (double)l.getBlockY(), (double)l.getBlockZ() + 0.5, event.getTo().getYaw(), event.getTo().getPitch()));
        } else {
            this.players.put(event.getPlayer().getName(), System.currentTimeMillis() + this.time);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.players.put(event.getPlayer().getName(), System.currentTimeMillis() + this.time);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        this.players.remove(event.getPlayer().getName());
    }

    @Override
    public boolean isEnabled() {
        return Config.getConfig().getBoolean("player-speed-limiter.enabled");
    }

    @Override
    public void setValues() {
        this.time = Config.getConfig().getLong("player-speed-limiter.chunk-to-chunk-time");
        this.modifyonlyfly = Config.getConfig().getBoolean("player-speed-limiter.limit-only-fly");
        this.players = new HashMap();
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.players.put(p.getName(), System.currentTimeMillis() + this.time);
        }
    }
}

