/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.listeners;

import me.minebuilders.clearlag.Config;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.modules.EventModule;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.GenericAttributes;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntityAISpawnListener
extends EventModule {
    private int zombie;
    private int skeleton;
    private int creeper;

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            this.setEntityRange((Entity)event.getEntity());
        }
    }

    @Override
    public boolean isEnabled() {
        if (Config.getConfig().getBoolean("mob-range.enabled")) {
            if (!Util.isClass("org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity")) {
                Util.warning("mob-range requires you to use spigot v1_8_R3 (1.8.6)");
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setValues() {
        this.zombie = Config.getConfig().getInt("mob-range.zombie");
        this.skeleton = Config.getConfig().getInt("mob-range.skeleton");
        this.creeper = Config.getConfig().getInt("mob-range.creeper");
        for (World w : Bukkit.getWorlds()) {
            for (Entity e : w.getEntities()) {
                this.setEntityRange(e);
            }
        }
    }

    public void setEntityRange(Entity e) {
        if (e instanceof Zombie) {
            ((EntityLiving)((CraftEntity)e).getHandle()).getAttributeInstance(GenericAttributes.FOLLOW_RANGE).setValue((double)this.zombie);
        } else if (e instanceof Skeleton) {
            ((EntityLiving)((CraftEntity)e).getHandle()).getAttributeInstance(GenericAttributes.FOLLOW_RANGE).setValue((double)this.skeleton);
        } else if (e instanceof Creeper) {
            ((EntityLiving)((CraftEntity)e).getHandle()).getAttributeInstance(GenericAttributes.FOLLOW_RANGE).setValue((double)this.creeper);
        }
    }
}

