/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.listeners;

import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.Config;
import me.minebuilders.clearlag.modules.EventModule;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;

public class MobLimitListener
extends EventModule {
    private int animallimit = 0;
    private int moblimit = 0;
    private int interval = 0;
    private int sched = -1;
    private World[] worlds;
    public boolean canAnimalspawn = true;
    public boolean canMobspawn = true;

    public void spawnCheck() {
        int animals = 0;
        int mosters = 0;
        World[] worldArray = this.worlds;
        int n = this.worlds.length;
        int n2 = 0;
        while (n2 < n) {
            World world = worldArray[n2];
            for (Entity e : world.getEntities()) {
                if (e instanceof Animals || e instanceof Villager) {
                    ++animals;
                }
                if (!(e instanceof Creature) && !(e instanceof Monster)) continue;
                ++mosters;
            }
            ++n2;
        }
        this.canAnimalspawn = mosters < this.moblimit;
        this.canMobspawn = animals < this.animallimit;
    }

    public void resetSheds() {
        if (this.sched != -1) {
            Bukkit.getServer().getScheduler().cancelTask(this.sched);
        }
        this.sched = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Clearlag.getInstance(), new Runnable(){

            @Override
            public void run() {
                MobLimitListener.this.spawnCheck();
            }
        }, (long)this.interval * 20L, (long)this.interval * 20L);
    }

    @EventHandler
    public void onMobSpawn(CreatureSpawnEvent e) {
        LivingEntity en = e.getEntity();
        if (en instanceof Animals && !this.canAnimalspawn) {
            e.setCancelled(true);
        } else if (en instanceof Creature && !this.canMobspawn) {
            e.setCancelled(true);
        }
    }

    @Override
    public boolean isEnabled() {
        return Config.getConfig().getBoolean("spawn-limiter.enabled");
    }

    @Override
    public void setValues() {
        this.worlds = Bukkit.getServer().getWorlds().toArray(new World[0]);
        this.animallimit = Config.getConfig().getInt("spawn-limiter.animals");
        this.moblimit = Config.getConfig().getInt("spawn-limiter.monsters");
        this.interval = Config.getConfig().getInt("spawn-limiter.interval");
        this.spawnCheck();
        this.resetSheds();
    }
}

