/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.listeners;

import me.minebuilders.clearlag.Config;
import me.minebuilders.clearlag.modules.EventModule;
import org.bukkit.Chunk;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class MobSpawerListener
extends EventModule {
    private boolean mobspawner = false;
    private int mobamount = 0;
    private int yradius;
    private boolean entitylimit = false;
    private boolean cleanchunk = false;
    private int enlimit = 0;
    private boolean disableWither = false;

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        LivingEntity e = event.getEntity();
        if (event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER)) {
            if (!this.mobspawner) {
                return;
            }
            int count = 0;
            for (Entity entity : e.getNearbyEntities(15.0, (double)this.yradius, 15.0)) {
                if (!(entity instanceof LivingEntity)) continue;
                ++count;
            }
            if (count >= this.mobamount) {
                event.setCancelled(true);
            }
        } else if (event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.BUILD_WITHER)) {
            if (this.disableWither) {
                e.remove();
            }
        } else {
            if (!this.entitylimit) {
                return;
            }
            Chunk c = e.getLocation().getChunk();
            if (c.getEntities().length >= this.enlimit) {
                event.setCancelled(true);
                if (this.cleanchunk) {
                    Entity[] entityArray = c.getEntities();
                    int n = entityArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Entity en = entityArray[n2];
                        if (en instanceof Animals || en instanceof Creature || en instanceof Arrow) {
                            en.remove();
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return Config.getConfig().getBoolean("mobspawner.enabled") || Config.getConfig().getBoolean("chunk-entity-limiter.enabled") || Config.getConfig().getBoolean("kill-mobs.disable-build-wither");
    }

    @Override
    public void setValues() {
        this.mobspawner = Config.getConfig().getBoolean("mobspawner.enabled");
        this.mobamount = Config.getConfig().getInt("mobspawner.max-spawn");
        this.yradius = Config.getConfig().getInt("mobspawner.y-radius");
        this.entitylimit = Config.getConfig().getBoolean("chunk-entity-limiter.enabled");
        this.cleanchunk = Config.getConfig().getBoolean("chunk-entity-limiter.clean-chunk");
        this.enlimit = Config.getConfig().getInt("chunk-entity-limiter.limit");
        this.disableWither = Config.getConfig().getBoolean("kill-mobs.disable-build-wither");
    }
}

