/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.removetype;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.minebuilders.clearlag.Config;
import me.minebuilders.clearlag.modules.ClearModule;
import org.bukkit.World;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Boat;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.TNTPrimed;

public class LimitClear
extends ClearModule {
    private boolean item = false;
    private List<Integer> ids = new ArrayList<Integer>();
    private List<String> worlds = new ArrayList<String>();
    private boolean itemframe = false;
    private boolean fallingblock = false;
    private boolean boat = false;
    private boolean experience = false;
    private boolean painting = false;
    private boolean projectile = false;
    private boolean tnt = false;
    private boolean minecart = false;
    private boolean arrow = false;
    private boolean snowball = false;
    private boolean fireball = false;
    private boolean ender = false;

    @Override
    public void load() {
        Configuration config = Config.getConfig();
        String path = this.getPath();
        this.item = config.getBoolean(String.valueOf(path) + ".item");
        this.itemframe = config.getBoolean(String.valueOf(path) + ".itemframe");
        this.fallingblock = config.getBoolean(String.valueOf(path) + ".falling-block");
        this.boat = config.getBoolean(String.valueOf(path) + ".boat");
        this.experience = config.getBoolean(String.valueOf(path) + ".experienceOrb");
        this.painting = config.getBoolean(String.valueOf(path) + ".painting");
        this.projectile = config.getBoolean(String.valueOf(path) + ".projectile");
        this.tnt = config.getBoolean(String.valueOf(path) + ".primed-tnt");
        this.minecart = config.getBoolean(String.valueOf(path) + ".minecart");
        this.arrow = config.getBoolean(String.valueOf(path) + ".arrow");
        this.snowball = config.getBoolean(String.valueOf(path) + ".snowball");
        this.fireball = config.getBoolean(String.valueOf(path) + ".fireball");
        this.ender = config.getBoolean(String.valueOf(path) + ".ender-signal");
        Iterator iterator = config.getIntegerList(String.valueOf(path) + ".item-filter").iterator();
        while (iterator.hasNext()) {
            int s = (Integer)iterator.next();
            this.ids.add(s);
        }
        for (String s : config.getStringList(String.valueOf(path) + ".world-filter")) {
            this.worlds.add(s);
        }
    }

    @Override
    public boolean isRemoveable(Entity e) {
        if (e instanceof Item) {
            return this.item && !this.ids.contains(((Item)e).getItemStack().getTypeId());
        }
        if (e instanceof ItemFrame) {
            return this.itemframe;
        }
        if (e instanceof FallingBlock) {
            return this.fallingblock;
        }
        if (e instanceof Boat) {
            return ((Boat)e).isEmpty() && this.boat;
        }
        if (e instanceof ExperienceOrb) {
            return this.experience;
        }
        if (e instanceof Painting) {
            return this.painting;
        }
        if (e instanceof Projectile) {
            return this.projectile;
        }
        if (e instanceof TNTPrimed) {
            return this.tnt;
        }
        if (e instanceof Minecart) {
            return ((Minecart)e).isEmpty() && this.minecart;
        }
        if (e instanceof Arrow) {
            return this.arrow;
        }
        if (e instanceof Snowball) {
            return this.snowball;
        }
        if (e instanceof Fireball) {
            return this.fireball;
        }
        if (e instanceof EnderPearl) {
            return this.ender;
        }
        return false;
    }

    @Override
    public boolean isWorldEnabled(World w) {
        return !this.worlds.contains(w.getName());
    }

    @Override
    public boolean isEnabled() {
        return Config.getConfig().getBoolean("limit.enable-limit");
    }

    @Override
    public String getPath() {
        return "limit";
    }
}

