/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.spawner;

import java.util.Random;
import me.minebuilders.clearlag.Modules;
import me.minebuilders.clearlag.spawner.SpawnSettings;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public abstract class Spawn {
    public SpawnSettings settings = Modules.SpawnSettings;
    public Random rg = new Random();
    public int maxtrys = this.settings.getMaxTry();

    public void spawnEntity(Location l) {
        int ran2;
        World w = l.getWorld();
        int x = l.getBlockX();
        int z = l.getBlockZ();
        int y = l.getBlockY();
        int ran1 = this.getRandomNumber();
        l = this.getSafeLoc(w, x += ran1, y, z += (ran2 = this.getRandomNumber()));
        if (l != null) {
            this.spawnRandomMob(l);
        }
    }

    public boolean isDay(World w) {
        long time = w.getTime();
        return time < 13300L || time > 23000L;
    }

    public boolean isNearOthers(Location l) {
        int d = this.settings.getRadiusFromEntity();
        for (Entity e : l.getWorld().getEntitiesByClass(LivingEntity.class)) {
            if (e instanceof Player || !(l.distanceSquared(e.getLocation()) < (double)d)) continue;
            return true;
        }
        return false;
    }

    public abstract void spawnRandomMob(Location var1);

    public int getRandomNumber() {
        int r = this.rg.nextInt(this.settings.getRadius()) - this.rg.nextInt(this.settings.getRadius());
        if (r <= this.settings.getRadiusFrom() && r >= -this.settings.getRadiusFrom()) {
            return this.getRandomNumber();
        }
        return r;
    }

    public Location getSafeLoc(World w, int x, int y, int z) {
        while (this.maxtrys > 0) {
            --this.maxtrys;
            Material m = Material.getMaterial((int)w.getBlockTypeIdAt(x, y, z));
            if (m.isSolid()) {
                ++y;
                continue;
            }
            if (w.getBlockTypeIdAt(x, y - 1, z) == 0) {
                --y;
                continue;
            }
            if (Material.getMaterial((int)w.getBlockTypeIdAt(x, y + 1, z)).isSolid()) {
                int ran1 = this.getRandomNumber();
                int ran2 = this.getRandomNumber();
                x += ran1;
                z += ran2;
                continue;
            }
            return new Location(w, (double)x, (double)y, (double)z);
        }
        return null;
    }
}

