/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.tasks;

import java.util.HashMap;
import me.minebuilders.clearlag.Modules;
import me.minebuilders.clearlag.modules.ClearModule;
import me.minebuilders.clearlag.modules.EventModule;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.Monster;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class HaltTask
extends EventModule {
    private HashMap<World, Integer[]> valuelist = new HashMap();

    @Override
    public void setValues() {
        for (World w : Bukkit.getWorlds()) {
            Modules.EntityManager.removeEntities(new ClearModule(){

                @Override
                public void load() {
                }

                @Override
                public boolean isRemoveable(Entity e) {
                    return e instanceof Item || e instanceof TNTPrimed || e instanceof ExperienceOrb || e instanceof FallingBlock || e instanceof Monster;
                }

                @Override
                public boolean isWorldEnabled(World w) {
                    return true;
                }

                @Override
                public String getPath() {
                    return null;
                }
            });
            Integer[] values = new Integer[6];
            values[0] = w.getAmbientSpawnLimit();
            w.setAmbientSpawnLimit(0);
            values[1] = w.getAnimalSpawnLimit();
            w.setAnimalSpawnLimit(0);
            values[2] = w.getMonsterSpawnLimit();
            w.setMonsterSpawnLimit(0);
            values[3] = (int)w.getTicksPerAnimalSpawns();
            w.setTicksPerAnimalSpawns(0);
            values[4] = (int)w.getTicksPerMonsterSpawns();
            w.setTicksPerMonsterSpawns(0);
            values[5] = w.getWaterAnimalSpawnLimit();
            w.setWaterAnimalSpawnLimit(0);
            this.valuelist.put(w, values);
        }
    }

    @Override
    public void stop() {
        super.stop();
        for (World w : this.valuelist.keySet()) {
            Integer[] values = this.valuelist.get(w);
            w.setAmbientSpawnLimit(values[0].intValue());
            w.setAnimalSpawnLimit(values[1].intValue());
            w.setMonsterSpawnLimit(values[2].intValue());
            w.setTicksPerAnimalSpawns(values[3].intValue());
            w.setTicksPerMonsterSpawns(values[4].intValue());
            w.setWaterAnimalSpawnLimit(values[5].intValue());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onFire(BlockIgniteEvent e) {
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onFireBurn(BlockBurnEvent e) {
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onExplode(EntityExplodeEvent e) {
        e.setCancelled(true);
        e.blockList().clear();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDecay(LeavesDecayEvent e) {
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onForm(BlockFormEvent e) {
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSpread(BlockSpreadEvent e) {
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onFade(BlockFadeEvent e) {
        e.setCancelled(true);
    }
}

