/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.tasks;

import java.util.ArrayList;
import me.minebuilders.clearlag.Config;
import me.minebuilders.clearlag.Modules;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.modules.TaskModule;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class LimitTask
extends TaskModule {
    @Override
    public void load() {
        this.resume();
    }

    @Override
    public void run() {
        ArrayList<Entity> ents = new ArrayList<Entity>();
        for (World w : Bukkit.getWorlds()) {
            ents.addAll(Modules.LimitClear.getRemovables(w.getEntities(), w));
        }
        int limit = Config.getConfig().getInt("limit.max");
        if (ents.size() <= limit) {
            return;
        }
        for (Entity entity : ents) {
            entity.remove();
        }
        if (Config.getConfig().getBoolean("limit.broadcast-removal")) {
            Bukkit.broadcastMessage((String)Util.color(Config.getConfig().getString("limit.broadcast-message").replace("+RemoveAmount", "" + ents.size())));
        }
        ents.clear();
    }

    @Override
    public void reload() {
        this.stop();
        this.load();
    }

    @Override
    public boolean isEnabled() {
        return Config.getConfig().getBoolean("limit.enable-limit");
    }

    @Override
    public int getInterval() {
        return Config.getConfig().getInt("limit.check-interval") * 20;
    }
}

