/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.tasks;

import me.minebuilders.clearlag.Config;
import me.minebuilders.clearlag.modules.TaskModule;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;

public class LiveTask
extends TaskModule {
    private int itemkilltime;
    private int entitykilltime;
    private int arrowkilltime;
    private boolean checkItem;
    private boolean checkEntity;
    private boolean checkArrow;

    @Override
    public void load() {
        Configuration c = Config.getConfig();
        String p = "live-time.";
        this.itemkilltime = c.getInt(String.valueOf(p) + "itemlivetime") * 20;
        this.entitykilltime = c.getInt(String.valueOf(p) + "moblivetime") * 20;
        this.arrowkilltime = c.getInt(String.valueOf(p) + "arrowkilltime") * 20;
        this.checkItem = c.getBoolean(String.valueOf(p) + "itemtimer");
        this.checkEntity = c.getBoolean(String.valueOf(p) + "mobtimer");
        this.checkArrow = c.getBoolean(String.valueOf(p) + "checkArrow");
        this.resume();
    }

    @Override
    public void run() {
        for (World w : Bukkit.getWorlds()) {
            for (Entity e : w.getEntities()) {
                if (this.checkEntity && e instanceof LivingEntity && !(e instanceof HumanEntity)) {
                    if (e.getTicksLived() <= this.entitykilltime) continue;
                    e.remove();
                    continue;
                }
                if (this.checkItem && e instanceof Item) {
                    if (e.getTicksLived() <= this.itemkilltime) continue;
                    e.remove();
                    continue;
                }
                if (!this.checkArrow || !(e instanceof Arrow) || e.getTicksLived() <= this.arrowkilltime) continue;
                e.remove();
            }
        }
    }

    @Override
    public void reload() {
        this.stop();
        this.load();
    }

    @Override
    public boolean isEnabled() {
        return Config.getConfig().getBoolean("live-time.enabled");
    }

    @Override
    public int getInterval() {
        return Config.getConfig().getInt("live-time.interval") * 20;
    }
}

