/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.tasks;

import java.util.List;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.Config;
import me.minebuilders.clearlag.Modules;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.modules.TaskModule;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class TPSCheckTask
extends TaskModule {
    private List<String> commands;
    private double tpslimit;

    @Override
    public void load() {
        this.commands = Config.getConfig().getStringList("tps-meter.commands");
        this.tpslimit = Config.getConfig().getDouble("tps-meter.tps-trigger");
        this.resume();
    }

    @Override
    public void run() {
        if (Modules.TPSTask.getTPS() < this.tpslimit) {
            try {
                for (String s : this.commands) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)s);
                }
            }
            catch (Exception e) {
                Util.warning("TPSCheckTask was unable to dispatch commands!");
            }
        }
    }

    @Override
    public void reload() {
        this.stop();
        this.load();
    }

    @Override
    public boolean isEnabled() {
        return Config.getConfig().getBoolean("tps-meter.enabled");
    }

    @Override
    public void resume() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Clearlag.getInstance(), (Runnable)this, (long)Config.getConfig().getInt("tps-meter.interval") * 20L, (long)Config.getConfig().getInt("tps-meter.interval") * 20L);
    }

    @Override
    public int getInterval() {
        return Config.getConfig().getInt("tps-meter.interval") * 20;
    }
}

