/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.BlockSafety;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.api.SafeTTeleporter;
import com.onarandombox.MultiverseCore.configuration.ConfigPropertyFactory;
import com.onarandombox.MultiverseCore.configuration.MVActiveConfigProperty;
import com.onarandombox.MultiverseCore.configuration.MVConfigProperty;
import com.onarandombox.MultiverseCore.enums.AllowedPortalType;
import com.onarandombox.MultiverseCore.enums.EnglishChatColor;
import com.onarandombox.MultiverseCore.event.MVWorldPropertyChangeEvent;
import com.onarandombox.MultiverseCore.exceptions.PropertyDoesNotExistException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class MVWorld
implements MultiverseWorld {
    private MultiverseCore plugin;
    private FileConfiguration config;
    private ConfigurationSection worldSection;
    private World world;
    private World.Environment environment;
    private Long seed;
    private String name;
    private Map<String, List<String>> masterList;
    private Map<String, MVConfigProperty<?>> propertyList;
    private Permission permission;
    private Permission exempt;
    private boolean canSave = false;
    private Map<String, String> propertyAliases;
    private Permission ignoreperm;
    private static final Map<String, String> TIME_ALIASES;
    private WorldType type;
    private static final int SPAWN_LOCATION_SEARCH_TOLERANCE = 16;
    private static final int SPAWN_LOCATION_SEARCH_RADIUS = 16;

    public MVWorld(World world, FileConfiguration config, MultiverseCore instance, Long seed, String generatorString, boolean fixSpawn) {
        this.config = config;
        this.plugin = instance;
        this.world = world;
        this.name = world.getName();
        this.seed = seed;
        this.environment = world.getEnvironment();
        this.type = world.getWorldType();
        this.initLists();
        this.worldSection = config.getConfigurationSection("worlds." + this.name);
        if (this.worldSection == null) {
            config.createSection("worlds." + this.name);
            this.worldSection = config.getConfigurationSection("worlds." + this.name);
        }
        if (generatorString != null) {
            this.worldSection.set("generator", (Object)generatorString);
        }
        if (seed != null) {
            this.worldSection.set("seed", (Object)this.seed);
        }
        this.worldSection.set("environment", (Object)this.environment.toString());
        this.worldSection.set("type", (Object)this.type.toString());
        ConfigPropertyFactory fac = new ConfigPropertyFactory(this.worldSection);
        this.propertyList = new HashMap();
        this.propertyList.put("hidden", fac.getNewProperty("hidden", false, "Sorry, 'hidden' must either be:" + ChatColor.GREEN + " true " + ChatColor.WHITE + "or" + ChatColor.RED + " false" + ChatColor.WHITE + "."));
        this.propertyList.put("alias", fac.getNewProperty("alias", "", "alias.name", "Alias must be a valid string."));
        this.propertyList.put("color", fac.getNewProperty("color", EnglishChatColor.WHITE, "alias.color", "Sorry, 'color' must either one of: " + EnglishChatColor.getAllColors()));
        this.propertyList.put("pvp", fac.getNewProperty("pvp", true, "pvp", "Sorry, 'pvp' must either be:" + ChatColor.GREEN + " true " + ChatColor.WHITE + "or" + ChatColor.RED + " false" + ChatColor.WHITE + ".", "setActualPVP"));
        this.propertyList.put("scale", fac.getNewProperty("scale", this.getDefaultScale(this.environment), "scale", "Scale must be a positive double value. ex: " + ChatColor.GOLD + "2.3", "verifyScaleSetProperly"));
        this.propertyList.put("respawn", fac.getNewProperty("respawn", "", "respawnworld", "You must set this to the " + ChatColor.GOLD + " NAME" + ChatColor.RED + " not alias of a world."));
        this.propertyList.put("weather", fac.getNewProperty("weather", true, "allowweather", "Sorry, 'weather' must either be:" + ChatColor.GREEN + " true " + ChatColor.WHITE + "or" + ChatColor.RED + " false" + ChatColor.WHITE + ".", "setActualWeather"));
        this.propertyList.put("difficulty", fac.getNewProperty("difficulty", Difficulty.EASY, "Difficulty must be set as one of the following: " + ChatColor.GREEN + "peaceful " + ChatColor.AQUA + "easy " + ChatColor.GOLD + "normal " + ChatColor.RED + "hard"));
        this.propertyList.put("animals", fac.getNewProperty("animals", true, "animals.spawn", "Sorry, 'animals' must either be:" + ChatColor.GREEN + " true " + ChatColor.WHITE + "or" + ChatColor.RED + " false" + ChatColor.WHITE + ".", "syncMobs"));
        this.propertyList.put("monsters", fac.getNewProperty("monsters", true, "monsters.spawn", "Sorry, 'monsters' must either be:" + ChatColor.GREEN + " true " + ChatColor.WHITE + "or" + ChatColor.RED + " false" + ChatColor.WHITE + ".", "syncMobs"));
        this.propertyList.put("currency", fac.getNewProperty("currency", -1, "entryfee.currency", "Currency must be an integer between -1 and the highest Minecraft item ID."));
        this.propertyList.put("price", fac.getNewProperty("price", 0.0, "entryfee.price", "Price must be a double value. ex: " + ChatColor.GOLD + "1.2" + ChatColor.WHITE + ". Set to a negative value to give players money for entering this world."));
        this.propertyList.put("hunger", fac.getNewProperty("hunger", true, "Sorry, 'hunger' must either be:" + ChatColor.GREEN + " true " + ChatColor.WHITE + "or" + ChatColor.RED + " false" + ChatColor.WHITE + "."));
        this.propertyList.put("autoheal", fac.getNewProperty("autoheal", true, "Sorry, 'autoheal' must either be:" + ChatColor.GREEN + " true " + ChatColor.WHITE + "or" + ChatColor.RED + " false" + ChatColor.WHITE + "."));
        this.propertyList.put("adjustspawn", fac.getNewProperty("adjustspawn", true, "Sorry, 'adjustspawn' must either be:" + ChatColor.GREEN + " true " + ChatColor.WHITE + "or" + ChatColor.RED + " false" + ChatColor.WHITE + "."));
        this.propertyList.put("portalform", fac.getNewProperty("portalform", AllowedPortalType.ALL, "Allow portal forming must be NONE, ALL, NETHER or END."));
        if (!fixSpawn) {
            this.setAdjustSpawn(false);
        }
        this.propertyList.put("gamemode", fac.getNewProperty("gamemode", GameMode.SURVIVAL, "GameMode must be set as one of the following: " + ChatColor.RED + "survival " + ChatColor.GREEN + "creative "));
        this.propertyList.put("memory", fac.getNewProperty("keepspawninmemory", true, "keepspawninmemory", "Sorry, 'memory' must either be:" + ChatColor.GREEN + " true " + ChatColor.WHITE + "or" + ChatColor.RED + " false" + ChatColor.WHITE + ".", "setActualKeepSpawnInMemory"));
        this.propertyList.put("spawn", fac.getNewProperty("spawn", this.world.getSpawnLocation(), "spawn", "There is no help available for this variable. Go bug Rigby90 about it.", "setActualKeepSpawnInMemory"));
        this.propertyList.put("autoload", fac.getNewProperty("autoload", true, "Set this to false ONLY if you don't want this world to load itself on server restart."));
        this.propertyList.put("bedrespawn", fac.getNewProperty("bedrespawn", true, "If a player dies in this world, shoudld they go to their bed?"));
        this.propertyList.put("time", fac.getNewProperty("time", "", "Set the time to whatever you want! (Will NOT freeze time)", "setActualTime", true));
        this.getKnownProperty("spawn", Location.class).setValue(this.readSpawnFromConfig(this.getCBWorld()));
        this.propertyAliases = new HashMap<String, String>();
        this.propertyAliases.put("curr", "currency");
        this.propertyAliases.put("scaling", "scale");
        this.propertyAliases.put("aliascolor", "color");
        this.propertyAliases.put("heal", "autoheal");
        this.propertyAliases.put("storm", "weather");
        this.propertyAliases.put("spawnmemory", "memory");
        this.propertyAliases.put("mode", "gamemode");
        this.propertyAliases.put("diff", "difficulty");
        this.getMobExceptions();
        List tempWorldBlacklist = this.worldSection.getStringList("worldblacklist");
        if (tempWorldBlacklist != null) {
            this.getWorldBlacklist().addAll(tempWorldBlacklist);
        }
        this.canSave = true;
        this.saveConfig();
        this.permission = new Permission("multiverse.access." + this.getName(), "Allows access to " + this.getName(), PermissionDefault.OP);
        this.ignoreperm = new Permission("mv.bypass.gamemode." + this.getName(), "Allows players with this permission to ignore gamemode changes.", PermissionDefault.FALSE);
        this.exempt = new Permission("multiverse.exempt." + this.getName(), "A player who has this does not pay to enter this world, or use any MV portals in it " + this.getName(), PermissionDefault.OP);
        try {
            this.plugin.getServer().getPluginManager().addPermission(this.permission);
            this.plugin.getServer().getPluginManager().addPermission(this.exempt);
            this.plugin.getServer().getPluginManager().addPermission(this.ignoreperm);
            this.addToUpperLists(this.permission);
            this.ignoreperm.addParent("mv.bypass.gamemode.*", true);
        }
        catch (IllegalArgumentException e) {
            this.plugin.log(Level.FINER, "Permissions nodes were already added for " + this.name);
        }
        this.setActualPVP();
        this.verifyScaleSetProperly();
        this.setActualKeepSpawnInMemory();
        this.setActualDifficulty();
        this.setActualGameMode();
        this.setActualSpawn();
        this.syncMobs();
    }

    public boolean setActualPVP() {
        this.world.setPVP(this.getKnownProperty("pvp", Boolean.class).getValue().booleanValue());
        return true;
    }

    public boolean verifyScaleSetProperly() {
        if (this.getKnownProperty("scale", Double.class).getValue() <= 0.0) {
            this.getKnownProperty("scale", Double.class).setValue(1.0);
            this.plugin.log(Level.WARNING, "Someone tried to set a scale <= 0, defaulting to 1.");
        }
        return true;
    }

    public boolean setActualKeepSpawnInMemory() {
        this.getCBWorld().setKeepSpawnInMemory(this.getKnownProperty("memory", Boolean.class).getValue().booleanValue());
        return true;
    }

    public boolean setActualDifficulty() {
        this.getCBWorld().setDifficulty(this.getKnownProperty("difficulty", Difficulty.class).getValue());
        return true;
    }

    public boolean setActualSpawn() {
        Location spawnLocation = this.getKnownProperty("spawn", Location.class).getValue();
        this.getCBWorld().setSpawnLocation(spawnLocation.getBlockX(), spawnLocation.getBlockY(), spawnLocation.getBlockZ());
        return true;
    }

    private double getDefaultScale(World.Environment environment) {
        if (environment == World.Environment.NETHER) {
            return 8.0;
        }
        return 1.0;
    }

    private void addToUpperLists(Permission permission) {
        Permission all = this.plugin.getServer().getPluginManager().getPermission("multiverse.*");
        Permission allWorlds = this.plugin.getServer().getPluginManager().getPermission("multiverse.access.*");
        Permission allExemption = this.plugin.getServer().getPluginManager().getPermission("multiverse.exempt.*");
        if (allWorlds == null) {
            allWorlds = new Permission("multiverse.access.*");
            this.plugin.getServer().getPluginManager().addPermission(allWorlds);
        }
        allWorlds.getChildren().put(permission.getName(), true);
        if (allExemption == null) {
            allExemption = new Permission("multiverse.exempt.*");
            this.plugin.getServer().getPluginManager().addPermission(allExemption);
        }
        allExemption.getChildren().put(this.exempt.getName(), true);
        if (all == null) {
            all = new Permission("multiverse.*");
            this.plugin.getServer().getPluginManager().addPermission(all);
        }
        all.getChildren().put("multiverse.access.*", true);
        all.getChildren().put("multiverse.exempt.*", true);
        this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(all);
        this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(allWorlds);
    }

    @Override
    public String getColoredWorldString() {
        EnglishChatColor worldColor = this.getKnownProperty("color", EnglishChatColor.class).getValue();
        String alias = this.getKnownProperty("alias", String.class).getValue();
        if (worldColor == null) {
            this.setKnownProperty("color", "WHITE", null);
            return alias + ChatColor.WHITE;
        }
        if (worldColor.getColor() == null) {
            return alias + ChatColor.WHITE;
        }
        if (alias.length() == 0) {
            alias = this.getName();
        }
        return worldColor.getColor() + alias + ChatColor.WHITE;
    }

    private void getMobExceptions() {
        List temp = this.worldSection.getStringList("animals.exceptions");
        if (temp != null) {
            for (String s : temp) {
                this.masterList.get("animals").add(s.toUpperCase());
            }
        }
        if ((temp = this.worldSection.getStringList("monsters.exceptions")) != null) {
            for (String s : temp) {
                this.masterList.get("monsters").add(s.toUpperCase());
            }
        }
    }

    @Override
    public World getCBWorld() {
        return this.world;
    }

    private void initLists() {
        this.masterList = new HashMap<String, List<String>>();
        this.masterList.put("worldblacklist", new ArrayList());
        this.masterList.put("animals", new ArrayList());
        this.masterList.put("monsters", new ArrayList());
    }

    @Override
    public boolean clearVariable(String property) {
        if (!this.masterList.keySet().contains(property)) {
            return false;
        }
        this.masterList.get(property).clear();
        this.worldSection.set(property.toLowerCase(), new ArrayList());
        this.saveConfig();
        return true;
    }

    @Override
    public boolean addToVariable(String property, String value) {
        property = property.toLowerCase();
        if (this.masterList.keySet().contains(property)) {
            if (property.equals("animals") || property.equals("monsters")) {
                this.masterList.get(property).add(value.toUpperCase());
                this.worldSection.set(property.toLowerCase() + ".exceptions", this.masterList.get(property));
                this.syncMobs();
            } else {
                this.masterList.get(property).add(value);
                this.worldSection.set(property.toLowerCase(), this.masterList.get(property));
            }
            this.saveConfig();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromVariable(String property, String value) {
        property = property.toLowerCase();
        if (this.masterList.keySet().contains(property)) {
            if (property.equals("animals") || property.equals("monsters")) {
                this.masterList.get(property).remove(value.toUpperCase());
                this.worldSection.set(property + ".exceptions", this.masterList.get(property));
                this.syncMobs();
            } else {
                this.masterList.get(property).remove(value);
                this.worldSection.set(property, this.masterList.get(property));
            }
            this.saveConfig();
            return true;
        }
        return false;
    }

    public void syncMobs() {
        if (this.getAnimalList().isEmpty()) {
            this.world.setSpawnFlags(this.world.getAllowMonsters(), this.getKnownProperty("animals", Boolean.class).getValue().booleanValue());
        } else {
            this.world.setSpawnFlags(this.world.getAllowMonsters(), true);
        }
        if (this.getMonsterList().isEmpty()) {
            this.world.setSpawnFlags(this.getKnownProperty("monsters", Boolean.class).getValue().booleanValue(), this.world.getAllowAnimals());
        } else {
            this.world.setSpawnFlags(true, this.world.getAllowAnimals());
        }
        this.plugin.getMVWorldManager().getTheWorldPurger().purgeWorld(this);
    }

    @Override
    public void setKeepSpawnInMemory(boolean value) {
        this.getKnownProperty("memory", Boolean.class).setValue(value);
        this.saveConfig();
    }

    @Override
    public boolean setProperty(String name, String value, CommandSender sender) throws PropertyDoesNotExistException {
        if (!this.isValidPropertyName(name)) {
            throw new PropertyDoesNotExistException(name);
        }
        return this.setKnownProperty(name, value, sender) || this.setKnownProperty(this.propertyAliases.get(name), value, sender);
    }

    private boolean isValidPropertyName(String name) {
        return this.propertyList.containsKey(name) || this.propertyAliases.containsKey(name);
    }

    @Override
    public String getPropertyValue(String name) throws PropertyDoesNotExistException {
        if (this.propertyList.containsKey(name)) {
            return ((Object)this.getKnownProperty(name, Object.class)).toString();
        }
        throw new PropertyDoesNotExistException(name);
    }

    @Override
    @Deprecated
    public MVConfigProperty<?> getProperty(String property) throws PropertyDoesNotExistException {
        return this.getProperty(property, Object.class);
    }

    @Override
    public <T> MVConfigProperty<T> getProperty(String name, Class<T> expected) throws PropertyDoesNotExistException {
        MVConfigProperty<T> p = this.getKnownProperty(name, expected);
        if (p == null) {
            throw new PropertyDoesNotExistException(name);
        }
        return p;
    }

    private <T> MVConfigProperty<T> getKnownProperty(String name, Class<T> expected) {
        try {
            if (this.propertyList.containsKey(name)) {
                return this.propertyList.get(name);
            }
            if (this.propertyAliases.containsKey(name)) {
                return this.propertyList.get(this.propertyAliases.get(name));
            }
        }
        catch (ClassCastException e) {
            return null;
        }
        return null;
    }

    private boolean setKnownProperty(String name, String value, CommandSender sender) {
        if (!this.propertyList.containsKey(name)) {
            if (this.propertyAliases.containsKey(name)) {
                return this.setKnownProperty(this.propertyAliases.get(name), value, sender);
            }
            return false;
        }
        MVConfigProperty<Object> property = this.getKnownProperty(name, Object.class);
        if (this.canSave) {
            MVWorldPropertyChangeEvent propertyChangeEvent = new MVWorldPropertyChangeEvent(this, sender, name, value);
            this.plugin.getServer().getPluginManager().callEvent((Event)propertyChangeEvent);
            if (propertyChangeEvent.isCancelled()) {
                this.plugin.log(Level.FINE, "Someone else cancelled the WorldPropertyChanged Event!!!");
                return false;
            }
            value = propertyChangeEvent.getNewValue();
        }
        if (property.parseValue(value)) {
            if (property instanceof MVActiveConfigProperty) {
                return this.setActiveProperty((MVActiveConfigProperty)property);
            }
            this.saveConfig();
            return true;
        }
        return false;
    }

    private boolean setActiveProperty(MVActiveConfigProperty<?> property) {
        try {
            if (property.getMethod() == null) {
                this.saveConfig();
                return true;
            }
            Method method = this.getClass().getMethod(property.getMethod(), new Class[0]);
            Object returnVal = method.invoke((Object)this, new Object[0]);
            if (returnVal instanceof Boolean) {
                if (((Boolean)returnVal).booleanValue()) {
                    this.saveConfig();
                }
                return (Boolean)returnVal;
            }
            this.saveConfig();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public World.Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(World.Environment environment) {
        this.environment = environment;
    }

    @Override
    public Long getSeed() {
        return this.seed;
    }

    @Override
    public void setSeed(Long seed) {
        this.seed = seed;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPermissibleName() {
        return this.name.toLowerCase();
    }

    @Override
    public String getAlias() {
        String alias = this.getKnownProperty("alias", String.class).getValue();
        if (alias == null || alias.length() == 0) {
            return this.name;
        }
        return alias;
    }

    @Override
    public void setAlias(String alias) {
        this.setKnownProperty("alias", alias, null);
    }

    @Override
    public boolean canAnimalsSpawn() {
        return this.getKnownProperty("animals", Boolean.class).getValue();
    }

    @Override
    public void setAllowAnimalSpawn(boolean animals) {
        this.setKnownProperty("animals", animals + "", null);
    }

    @Override
    public List<String> getAnimalList() {
        return this.masterList.get("animals");
    }

    @Override
    public boolean canMonstersSpawn() {
        return this.getKnownProperty("monsters", Boolean.class).getValue();
    }

    @Override
    public void setAllowMonsterSpawn(boolean monsters) {
        this.setKnownProperty("monsters", monsters + "", null);
    }

    @Override
    public List<String> getMonsterList() {
        return this.masterList.get("monsters");
    }

    @Override
    public boolean isPVPEnabled() {
        return this.getKnownProperty("pvp", Boolean.class).getValue();
    }

    @Override
    public void setPVPMode(boolean pvp) {
        this.setKnownProperty("pvp", pvp + "", null);
    }

    @Override
    public boolean isHidden() {
        return this.getKnownProperty("hidden", Boolean.class).getValue();
    }

    @Override
    public void setHidden(boolean hidden) {
        this.setKnownProperty("hidden", hidden + "", null);
    }

    @Override
    public List<String> getWorldBlacklist() {
        return this.masterList.get("worldblacklist");
    }

    @Override
    public double getScaling() {
        return this.getKnownProperty("scale", Double.class).getValue();
    }

    @Override
    public boolean setScaling(double scaling) {
        return this.setKnownProperty("scale", scaling + "", null);
    }

    @Override
    public boolean setColor(String aliasColor) {
        return this.setKnownProperty("color", aliasColor, null);
    }

    @Override
    public boolean isValidAliasColor(String aliasColor) {
        return EnglishChatColor.fromString(aliasColor) != null;
    }

    @Override
    public ChatColor getColor() {
        return this.getKnownProperty("color", EnglishChatColor.class).getValue().getColor();
    }

    @Override
    public boolean clearList(String property) {
        if (this.masterList.containsKey(property)) {
            this.masterList.get(property).clear();
            this.worldSection.set(property.toLowerCase(), this.masterList.get(property));
            this.syncMobs();
            this.saveConfig();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean getFakePVP() {
        return false;
    }

    @Override
    public World getRespawnToWorld() {
        return this.plugin.getServer().getWorld(this.getKnownProperty("respawn", String.class).getValue());
    }

    @Override
    public boolean setRespawnToWorld(String respawnToWorld) {
        if (!this.plugin.getMVWorldManager().isMVWorld(respawnToWorld)) {
            return false;
        }
        return this.setKnownProperty("respawn", respawnToWorld, null);
    }

    @Override
    public Permission getAccessPermission() {
        return this.permission;
    }

    @Override
    public int getCurrency() {
        return this.getKnownProperty("curr", Integer.class).getValue();
    }

    @Override
    public void setCurrency(int currency) {
        this.setKnownProperty("curr", currency + "", null);
    }

    @Override
    public double getPrice() {
        return this.getKnownProperty("price", Double.class).getValue();
    }

    @Override
    public void setPrice(double price) {
        this.setKnownProperty("price", price + "", null);
    }

    @Override
    public Permission getExemptPermission() {
        return this.exempt;
    }

    private void saveConfig() {
        if (this.canSave) {
            try {
                this.config.save(new File(this.plugin.getDataFolder(), "worlds.yml"));
            }
            catch (IOException e) {
                this.plugin.log(Level.SEVERE, "Could not save worlds.yml. Please check your filesystem permissions.");
            }
        }
    }

    @Override
    public boolean setGameMode(String gameMode) {
        return this.setKnownProperty("mode", gameMode, null);
    }

    public boolean setActualGameMode() {
        for (Player p : this.plugin.getServer().getWorld(this.getName()).getPlayers()) {
            this.plugin.log(Level.FINER, String.format("Setting %s's GameMode to %s", p.getName(), this.getKnownProperty("mode", GameMode.class).getValue().toString()));
            this.plugin.getPlayerListener().handleGameMode(p, this);
        }
        return true;
    }

    @Override
    public GameMode getGameMode() {
        return this.getKnownProperty("mode", GameMode.class).getValue();
    }

    @Override
    public void setEnableWeather(boolean weather) {
        this.setKnownProperty("weather", weather + "", null);
    }

    public boolean setActualWeather() {
        if (!this.getKnownProperty("weather", Boolean.class).getValue().booleanValue()) {
            this.getCBWorld().setStorm(false);
            this.getCBWorld().setThundering(false);
        }
        return true;
    }

    @Override
    public boolean isWeatherEnabled() {
        return this.getKnownProperty("weather", Boolean.class).getValue();
    }

    @Override
    public boolean isKeepingSpawnInMemory() {
        return this.getKnownProperty("memory", Boolean.class).getValue();
    }

    @Override
    public void setHunger(boolean hunger) {
        this.setKnownProperty("hunger", hunger + "", null);
    }

    @Override
    public boolean getHunger() {
        return this.getKnownProperty("hunger", Boolean.class).getValue();
    }

    @Override
    public void setSpawnLocation(Location l) {
        this.getCBWorld().setSpawnLocation(l.getBlockX(), l.getBlockY(), l.getBlockZ());
        this.getKnownProperty("spawn", Location.class).setValue(l);
        this.saveConfig();
    }

    private Location readSpawnFromConfig(World w) {
        Location spawnLocation = w.getSpawnLocation();
        Location configLocation = this.getSpawnLocation();
        w.setSpawnLocation(configLocation.getBlockX(), configLocation.getBlockY(), configLocation.getBlockZ());
        SafeTTeleporter teleporter = this.plugin.getSafeTTeleporter();
        BlockSafety bs = this.plugin.getBlockSafety();
        if (!bs.playerCanSpawnHereSafely(configLocation)) {
            if (!this.getAdjustSpawn()) {
                this.plugin.log(Level.FINE, "Spawn location from world.dat file was unsafe!!");
                this.plugin.log(Level.FINE, "NOT adjusting spawn for '" + this.getAlias() + "' because you told me not to.");
                this.plugin.log(Level.FINE, "To turn on spawn adjustment for this world simply type:");
                this.plugin.log(Level.FINE, "/mvm set adjustspawn true " + this.getAlias());
                return configLocation;
            }
            this.plugin.log(Level.WARNING, "Spawn location from world.dat file was unsafe. Adjusting...");
            this.plugin.log(Level.WARNING, "Original Location: " + this.plugin.getLocationManipulation().strCoordsRaw(spawnLocation));
            Location newSpawn = teleporter.getSafeLocation(spawnLocation, 16, 16);
            if (newSpawn != null) {
                this.setSpawnLocation(newSpawn);
                configLocation = this.getSpawnLocation();
                this.plugin.log(Level.INFO, "New Spawn for '" + this.getName() + "' is Located at: " + this.plugin.getLocationManipulation().locationToString(configLocation));
            } else {
                Location newerSpawn = bs.getTopBlock(new Location(w, 0.0, 0.0, 0.0));
                if (newerSpawn != null) {
                    this.setSpawnLocation(newerSpawn);
                    configLocation = this.getSpawnLocation();
                    this.plugin.log(Level.INFO, "New Spawn for '" + this.getName() + "' is Located at: " + this.plugin.getLocationManipulation().locationToString(configLocation));
                } else {
                    this.plugin.log(Level.SEVERE, "New safe spawn NOT found!!!");
                }
            }
        }
        return configLocation;
    }

    @Override
    public Location getSpawnLocation() {
        return this.getKnownProperty("spawn", Location.class).getValue();
    }

    @Override
    public Difficulty getDifficulty() {
        return this.getCBWorld().getDifficulty();
    }

    @Override
    public boolean setDifficulty(String difficulty) {
        if (this.setKnownProperty("diff", difficulty, null)) {
            this.getCBWorld().setDifficulty(this.getKnownProperty("diff", Difficulty.class).getValue());
            return true;
        }
        return false;
    }

    @Override
    public boolean getAutoHeal() {
        return this.getKnownProperty("autoheal", Boolean.class).getValue();
    }

    @Override
    public void setAutoHeal(boolean heal) {
        this.setKnownProperty("autoheal", heal + "", null);
    }

    @Override
    public void setAdjustSpawn(boolean adjust) {
        this.setKnownProperty("adjustspawn", adjust + "", null);
    }

    @Override
    public boolean getAdjustSpawn() {
        return this.getKnownProperty("adjustspawn", Boolean.class).getValue();
    }

    @Override
    public void setAutoLoad(boolean autoLoad) {
        this.setKnownProperty("autoload", autoLoad + "", null);
    }

    @Override
    public boolean getAutoLoad() {
        return this.getKnownProperty("autoload", Boolean.class).getValue();
    }

    @Override
    public void setBedRespawn(boolean respawn) {
        this.setKnownProperty("bedrespawn", respawn + "", null);
    }

    @Override
    public boolean getBedRespawn() {
        return this.getKnownProperty("bedrespawn", Boolean.class).getValue();
    }

    @Override
    public String getAllPropertyNames() {
        ChatColor color = ChatColor.AQUA;
        String result = "";
        for (String propertyNames : this.propertyList.keySet()) {
            result = result + color + propertyNames + " ";
            color = color == ChatColor.AQUA ? ChatColor.GOLD : ChatColor.AQUA;
        }
        return result;
    }

    @Override
    public String getTime() {
        long time = this.getCBWorld().getTime();
        int hours = (int)((time / 1000L + 8L) % 24L);
        int minutes = (int)(60L * (time % 1000L) / 1000L);
        return String.format("%d:%02d", hours, minutes);
    }

    @Override
    public WorldType getWorldType() {
        return this.type;
    }

    @Override
    public void allowPortalMaking(AllowedPortalType type) {
        this.setKnownProperty("portalform", type.toString(), null);
    }

    @Override
    public AllowedPortalType getAllowedPortals() {
        return this.getKnownProperty("portalform", AllowedPortalType.class).getValue();
    }

    public boolean setActualTime() {
        return this.setTime(((Object)this.getKnownProperty("time", String.class)).toString());
    }

    @Override
    public boolean setTime(String timeAsString) {
        if (TIME_ALIASES.containsKey(timeAsString.toLowerCase())) {
            return this.setTime(TIME_ALIASES.get(timeAsString.toLowerCase()));
        }
        String timeRegex = "(\\d\\d?):?(\\d\\d)(a|p)?m?";
        Pattern pattern = Pattern.compile(timeRegex, 2);
        Matcher matcher = pattern.matcher(timeAsString);
        matcher.find();
        int hour = 0;
        double minute = 0.0;
        int count = matcher.groupCount();
        if (count >= 2) {
            hour = Integer.parseInt(matcher.group(1));
            minute = Integer.parseInt(matcher.group(2));
        }
        if (count == 4 && matcher.group(3).equals("p")) {
            hour += 12;
        }
        if (hour == 24) {
            hour = 0;
        }
        if (hour > 23 || hour < 0) {
            return false;
        }
        if (minute > 59.0 || minute < 0.0) {
            return false;
        }
        double totaltime = ((double)hour + minute / 60.0) * 1000.0;
        if ((totaltime -= 8000.0) < 0.0) {
            totaltime = 24000.0 + totaltime;
        }
        this.getCBWorld().setTime((long)totaltime);
        return true;
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        toStringBuilder.append(this.getClass().getSimpleName());
        toStringBuilder.append('@');
        toStringBuilder.append(this.hashCode());
        toStringBuilder.append(" (Name: '").append(this.getName()).append("')");
        return toStringBuilder.toString();
    }

    static {
        HashMap<String, String> staticTimes = new HashMap<String, String>();
        staticTimes.put("morning", "8:00");
        staticTimes.put("day", "12:00");
        staticTimes.put("noon", "12:00");
        staticTimes.put("midnight", "0:00");
        staticTimes.put("night", "20:00");
        TIME_ALIASES = Collections.unmodifiableMap(staticTimes);
    }
}

