/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore;

import com.fernferret.allpay.multiverse.AllPay;
import com.fernferret.allpay.multiverse.GenericBank;
import com.onarandombox.MultiverseCore.MultiverseCoreConfiguration;
import com.onarandombox.MultiverseCore.api.BlockSafety;
import com.onarandombox.MultiverseCore.api.Core;
import com.onarandombox.MultiverseCore.api.LocationManipulation;
import com.onarandombox.MultiverseCore.api.MVPlugin;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseCoreConfig;
import com.onarandombox.MultiverseCore.api.MultiverseMessaging;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.api.SafeTTeleporter;
import com.onarandombox.MultiverseCore.commands.AnchorCommand;
import com.onarandombox.MultiverseCore.commands.CheckCommand;
import com.onarandombox.MultiverseCore.commands.ConfigCommand;
import com.onarandombox.MultiverseCore.commands.ConfirmCommand;
import com.onarandombox.MultiverseCore.commands.CoordCommand;
import com.onarandombox.MultiverseCore.commands.CreateCommand;
import com.onarandombox.MultiverseCore.commands.DebugCommand;
import com.onarandombox.MultiverseCore.commands.DeleteCommand;
import com.onarandombox.MultiverseCore.commands.EnvironmentCommand;
import com.onarandombox.MultiverseCore.commands.GeneratorCommand;
import com.onarandombox.MultiverseCore.commands.HelpCommand;
import com.onarandombox.MultiverseCore.commands.ImportCommand;
import com.onarandombox.MultiverseCore.commands.InfoCommand;
import com.onarandombox.MultiverseCore.commands.ListCommand;
import com.onarandombox.MultiverseCore.commands.LoadCommand;
import com.onarandombox.MultiverseCore.commands.ModifyAddCommand;
import com.onarandombox.MultiverseCore.commands.ModifyClearCommand;
import com.onarandombox.MultiverseCore.commands.ModifyCommand;
import com.onarandombox.MultiverseCore.commands.ModifyRemoveCommand;
import com.onarandombox.MultiverseCore.commands.ModifySetCommand;
import com.onarandombox.MultiverseCore.commands.PurgeCommand;
import com.onarandombox.MultiverseCore.commands.RegenCommand;
import com.onarandombox.MultiverseCore.commands.ReloadCommand;
import com.onarandombox.MultiverseCore.commands.RemoveCommand;
import com.onarandombox.MultiverseCore.commands.SetSpawnCommand;
import com.onarandombox.MultiverseCore.commands.SpawnCommand;
import com.onarandombox.MultiverseCore.commands.TeleportCommand;
import com.onarandombox.MultiverseCore.commands.UnloadCommand;
import com.onarandombox.MultiverseCore.commands.VersionCommand;
import com.onarandombox.MultiverseCore.commands.WhoCommand;
import com.onarandombox.MultiverseCore.destination.AnchorDestination;
import com.onarandombox.MultiverseCore.destination.BedDestination;
import com.onarandombox.MultiverseCore.destination.CannonDestination;
import com.onarandombox.MultiverseCore.destination.DestinationFactory;
import com.onarandombox.MultiverseCore.destination.ExactDestination;
import com.onarandombox.MultiverseCore.destination.PlayerDestination;
import com.onarandombox.MultiverseCore.destination.WorldDestination;
import com.onarandombox.MultiverseCore.listeners.MVEntityListener;
import com.onarandombox.MultiverseCore.listeners.MVPlayerListener;
import com.onarandombox.MultiverseCore.listeners.MVPluginListener;
import com.onarandombox.MultiverseCore.listeners.MVPortalListener;
import com.onarandombox.MultiverseCore.listeners.MVWeatherListener;
import com.onarandombox.MultiverseCore.utils.AnchorManager;
import com.onarandombox.MultiverseCore.utils.DebugLog;
import com.onarandombox.MultiverseCore.utils.MVMessaging;
import com.onarandombox.MultiverseCore.utils.MVPermissions;
import com.onarandombox.MultiverseCore.utils.MVPlayerSession;
import com.onarandombox.MultiverseCore.utils.SimpleBlockSafety;
import com.onarandombox.MultiverseCore.utils.SimpleLocationManipulation;
import com.onarandombox.MultiverseCore.utils.SimpleSafeTTeleporter;
import com.onarandombox.MultiverseCore.utils.WorldManager;
import com.pneumaticraft.commandhandler.multiverse.CommandHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.main__.util.multiverse.SerializationConfig.SerializationConfig;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MultiverseCore
extends JavaPlugin
implements MVPlugin,
Core {
    private static final int PROTOCOL = 14;
    private static Map<String, String> teleportQueue = new HashMap<String, String>();
    private AnchorManager anchorManager = new AnchorManager(this);
    private MultiverseCoreConfiguration config;
    private static final Logger LOGGER = Logger.getLogger("Minecraft");
    private static DebugLog debugLog;
    private CommandHandler commandHandler;
    private static final String LOG_TAG = "[Multiverse-Core]";
    private MVPermissions ph;
    private FileConfiguration multiverseConfig = null;
    private MVWorldManager worldManager = new WorldManager(this);
    private MVPlayerListener playerListener = new MVPlayerListener(this);
    private MVEntityListener entityListener = new MVEntityListener(this);
    private MVPluginListener pluginListener = new MVPluginListener(this);
    private MVWeatherListener weatherListener = new MVWeatherListener(this);
    private MVPortalListener portalListener = new MVPortalListener(this);
    private HashMap<String, MVPlayerSession> playerSessions;
    private GenericBank bank = null;
    private AllPay banker;
    private int pluginCount;
    private DestinationFactory destFactory;
    private MultiverseMessaging messaging;
    private BlockSafety blockSafety;
    private LocationManipulation locationManipulation;
    private SafeTTeleporter safeTTeleporter;
    private File serverFolder = new File(System.getProperty("user.dir"));

    public static String getPlayerTeleporter(String playerName) {
        if (teleportQueue.containsKey(playerName)) {
            String teleportee = teleportQueue.get(playerName);
            teleportQueue.remove(playerName);
            return teleportee;
        }
        return null;
    }

    public static void addPlayerToTeleportQueue(String teleporter, String teleportee) {
        MultiverseCore.staticLog(Level.FINEST, "Adding mapping '" + teleporter + "' => '" + teleportee + "' to teleport queue");
        teleportQueue.put(teleportee, teleporter);
    }

    public String toString() {
        return "The Multiverse-Core Plugin";
    }

    @Override
    @Deprecated
    public String dumpVersionInfo(String buffer) {
        return buffer;
    }

    @Override
    public MultiverseCore getCore() {
        return this;
    }

    @Override
    public void setCore(MultiverseCore core) {
    }

    @Override
    public int getProtocolVersion() {
        return 14;
    }

    public void onLoad() {
        SerializationConfig.registerAll(MultiverseCoreConfiguration.class);
        this.getDataFolder().mkdirs();
        debugLog = new DebugLog("Multiverse-Core", this.getDataFolder() + File.separator + "debug.log");
        this.blockSafety = new SimpleBlockSafety(this);
        this.locationManipulation = new SimpleLocationManipulation();
        this.safeTTeleporter = new SimpleSafeTTeleporter(this);
    }

    @Override
    @Deprecated
    public FileConfiguration getMVConfiguration() {
        return this.multiverseConfig;
    }

    @Override
    public GenericBank getBank() {
        return this.bank;
    }

    public void onEnable() {
        this.messaging = new MVMessaging();
        this.banker = new AllPay((Plugin)this, "[Multiverse-Core] ");
        this.log(Level.INFO, "- Version " + this.getDescription().getVersion() + " (API v" + 14 + ") Enabled - By " + this.getAuthors());
        this.worldManager.getDefaultWorldGenerators();
        this.registerEvents();
        this.ph = new MVPermissions(this);
        this.bank = this.banker.loadEconPlugin();
        this.commandHandler = new CommandHandler((Plugin)this, this.ph);
        this.registerCommands();
        this.initializeDestinationFactory();
        this.playerSessions = new HashMap();
        this.loadConfigs();
        if (this.multiverseConfig != null) {
            this.worldManager.loadDefaultWorlds();
            this.worldManager.loadWorlds(true);
        } else {
            this.log(Level.SEVERE, "Your configs were not loaded. Very little will function in Multiverse.");
        }
        this.anchorManager.loadAnchors();
        this.worldManager.setFirstSpawnWorld(this.config.getFirstSpawnWorld());
        try {
            this.config.setFirstSpawnWorld(this.worldManager.getFirstSpawnWorld().getName());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.saveMVConfig();
    }

    private void initializeDestinationFactory() {
        this.destFactory = new DestinationFactory(this);
        this.destFactory.registerDestinationType(WorldDestination.class, "");
        this.destFactory.registerDestinationType(WorldDestination.class, "w");
        this.destFactory.registerDestinationType(ExactDestination.class, "e");
        this.destFactory.registerDestinationType(PlayerDestination.class, "pl");
        this.destFactory.registerDestinationType(CannonDestination.class, "ca");
        this.destFactory.registerDestinationType(BedDestination.class, "b");
        this.destFactory.registerDestinationType(AnchorDestination.class, "a");
    }

    private void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.playerListener, (Plugin)this);
        pm.registerEvents((Listener)this.entityListener, (Plugin)this);
        pm.registerEvents((Listener)this.pluginListener, (Plugin)this);
        pm.registerEvents((Listener)this.weatherListener, (Plugin)this);
        pm.registerEvents((Listener)this.portalListener, (Plugin)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void loadConfigs() {
        this.multiverseConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "config.yml"));
        YamlConfiguration coreDefaults = YamlConfiguration.loadConfiguration((InputStream)this.getClass().getResourceAsStream("/defaults/config.yml"));
        this.multiverseConfig.setDefaults((Configuration)coreDefaults);
        this.multiverseConfig.options().copyDefaults(false);
        this.multiverseConfig.options().copyHeader(true);
        this.worldManager.loadWorldConfig(new File(this.getDataFolder(), "worlds.yml"));
        MultiverseCoreConfiguration wantedConfig = null;
        try {
            wantedConfig = (MultiverseCoreConfiguration)this.multiverseConfig.get("multiverse-configuration");
            this.config = wantedConfig == null ? new MultiverseCoreConfiguration() : wantedConfig;
        }
        catch (Exception exception) {
            this.config = wantedConfig == null ? new MultiverseCoreConfiguration() : wantedConfig;
            catch (Throwable throwable) {
                this.config = wantedConfig == null ? new MultiverseCoreConfiguration() : wantedConfig;
                throw throwable;
            }
        }
        this.messaging.setCooldown(this.config.getMessageCooldown());
        this.multiverseConfig.set("enforcegamemodes", null);
        this.multiverseConfig.set("bedrespawn", null);
        this.multiverseConfig.set("opfallback", null);
        this.migrate22Values();
        this.saveMVConfigs();
    }

    private void migrate22Values() {
        if (this.multiverseConfig.isSet("worldnameprefix")) {
            this.log(Level.INFO, "Migrating 'worldnameprefix'...");
            this.config.setPrefixChat(this.multiverseConfig.getBoolean("worldnameprefix"));
            this.multiverseConfig.set("worldnameprefix", null);
        }
        if (this.multiverseConfig.isSet("firstspawnworld")) {
            this.log(Level.INFO, "Migrating 'firstspawnworld'...");
            this.config.setFirstSpawnWorld(this.multiverseConfig.getString("firstspawnworld"));
            this.multiverseConfig.set("firstspawnworld", null);
        }
        if (this.multiverseConfig.isSet("enforceaccess")) {
            this.log(Level.INFO, "Migrating 'enforceaccess'...");
            this.config.setEnforceAccess(this.multiverseConfig.getBoolean("enforceaccess"));
            this.multiverseConfig.set("enforceaccess", null);
        }
        if (this.multiverseConfig.isSet("displaypermerrors")) {
            this.log(Level.INFO, "Migrating 'displaypermerrors'...");
            this.config.setDisplayPermErrors(this.multiverseConfig.getBoolean("displaypermerrors"));
            this.multiverseConfig.set("displaypermerrors", null);
        }
        if (this.multiverseConfig.isSet("teleportintercept")) {
            this.log(Level.INFO, "Migrating 'teleportintercept'...");
            this.config.setTeleportIntercept(this.multiverseConfig.getBoolean("teleportintercept"));
            this.multiverseConfig.set("teleportintercept", null);
        }
        if (this.multiverseConfig.isSet("firstspawnoverride")) {
            this.log(Level.INFO, "Migrating 'firstspawnoverride'...");
            this.config.setFirstSpawnOverride(this.multiverseConfig.getBoolean("firstspawnoverride"));
            this.multiverseConfig.set("firstspawnoverride", null);
        }
        if (this.multiverseConfig.isSet("messagecooldown")) {
            this.log(Level.INFO, "Migrating 'messagecooldown'...");
            this.config.setMessageCooldown(this.multiverseConfig.getInt("messagecooldown"));
            this.multiverseConfig.set("messagecooldown", null);
        }
        if (this.multiverseConfig.isSet("debug")) {
            this.log(Level.INFO, "Migrating 'debug'...");
            this.config.setGlobalDebug(this.multiverseConfig.getInt("debug"));
            this.multiverseConfig.set("debug", null);
        }
        if (this.multiverseConfig.isSet("version")) {
            this.log(Level.INFO, "Migrating 'version'...");
            this.multiverseConfig.set("version", null);
        }
    }

    @Override
    public MultiverseMessaging getMessaging() {
        return this.messaging;
    }

    private void registerCommands() {
        this.commandHandler.registerCommand(new HelpCommand(this));
        this.commandHandler.registerCommand(new VersionCommand(this));
        this.commandHandler.registerCommand(new ListCommand(this));
        this.commandHandler.registerCommand(new InfoCommand(this));
        this.commandHandler.registerCommand(new CreateCommand(this));
        this.commandHandler.registerCommand(new ImportCommand(this));
        this.commandHandler.registerCommand(new ReloadCommand(this));
        this.commandHandler.registerCommand(new SetSpawnCommand(this));
        this.commandHandler.registerCommand(new CoordCommand(this));
        this.commandHandler.registerCommand(new TeleportCommand(this));
        this.commandHandler.registerCommand(new WhoCommand(this));
        this.commandHandler.registerCommand(new SpawnCommand(this));
        this.commandHandler.registerCommand(new UnloadCommand(this));
        this.commandHandler.registerCommand(new LoadCommand(this));
        this.commandHandler.registerCommand(new RemoveCommand(this));
        this.commandHandler.registerCommand(new DeleteCommand(this));
        this.commandHandler.registerCommand(new RegenCommand(this));
        this.commandHandler.registerCommand(new ConfirmCommand(this));
        this.commandHandler.registerCommand(new ModifyCommand(this));
        this.commandHandler.registerCommand(new PurgeCommand(this));
        this.commandHandler.registerCommand(new ModifyAddCommand(this));
        this.commandHandler.registerCommand(new ModifySetCommand(this));
        this.commandHandler.registerCommand(new ModifyRemoveCommand(this));
        this.commandHandler.registerCommand(new ModifyClearCommand(this));
        this.commandHandler.registerCommand(new ConfigCommand(this));
        this.commandHandler.registerCommand(new AnchorCommand(this));
        this.commandHandler.registerCommand(new EnvironmentCommand(this));
        this.commandHandler.registerCommand(new DebugCommand(this));
        this.commandHandler.registerCommand(new GeneratorCommand(this));
        this.commandHandler.registerCommand(new CheckCommand(this));
    }

    public void onDisable() {
        debugLog.close();
        this.banker = null;
        this.bank = null;
        this.log(Level.INFO, "- Disabled");
    }

    @Override
    public MVPlayerSession getPlayerSession(Player player) {
        if (this.playerSessions.containsKey(player.getName())) {
            return this.playerSessions.get(player.getName());
        }
        this.playerSessions.put(player.getName(), new MVPlayerSession(player, this.config));
        return this.playerSessions.get(player.getName());
    }

    @Override
    @Deprecated
    public com.onarandombox.MultiverseCore.utils.SafeTTeleporter getTeleporter() {
        return new com.onarandombox.MultiverseCore.utils.SafeTTeleporter(this);
    }

    @Override
    public MVPermissions getMVPerms() {
        return this.ph;
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        if (!this.isEnabled()) {
            sender.sendMessage("This plugin is Disabled!");
            return true;
        }
        ArrayList<String> allArgs = new ArrayList<String>(Arrays.asList(args));
        allArgs.add(0, command.getName());
        return this.commandHandler.locateAndRunCommand(sender, allArgs, this.config.getDisplayPermErrors());
    }

    @Override
    public void log(Level level, String msg) {
        MultiverseCore.staticLog(level, msg);
    }

    public static void staticLog(Level level, String msg) {
        if (level == Level.FINE && MultiverseCoreConfiguration.getInstance().getGlobalDebug() >= 1) {
            MultiverseCore.staticDebugLog(Level.INFO, msg);
            return;
        }
        if (level == Level.FINER && MultiverseCoreConfiguration.getInstance().getGlobalDebug() >= 2) {
            MultiverseCore.staticDebugLog(Level.INFO, msg);
            return;
        }
        if (level == Level.FINEST && MultiverseCoreConfiguration.getInstance().getGlobalDebug() >= 3) {
            MultiverseCore.staticDebugLog(Level.INFO, msg);
            return;
        }
        if (level != Level.FINE && level != Level.FINER && level != Level.FINEST) {
            LOGGER.log(level, String.format("%s %s", LOG_TAG, msg));
            debugLog.log(level, String.format("%s %s", LOG_TAG, msg));
        }
    }

    public static void staticDebugLog(Level level, String msg) {
        LOGGER.log(level, "[MVCore-Debug] " + msg);
        debugLog.log(level, "[MVCore-Debug] " + msg);
    }

    @Override
    public String getAuthors() {
        String authors = "";
        List auths = this.getDescription().getAuthors();
        if (auths.size() == 0) {
            return "";
        }
        if (auths.size() == 1) {
            return (String)auths.get(0);
        }
        for (int i = 0; i < auths.size(); ++i) {
            authors = i == this.getDescription().getAuthors().size() - 1 ? authors + " and " + (String)this.getDescription().getAuthors().get(i) : authors + ", " + (String)this.getDescription().getAuthors().get(i);
        }
        return authors.substring(2);
    }

    @Override
    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public String getTag() {
        return LOG_TAG;
    }

    public void showNotMVWorldMessage(CommandSender sender, String worldName) {
        sender.sendMessage("Multiverse doesn't know about " + ChatColor.DARK_AQUA + worldName + ChatColor.WHITE + " yet.");
        sender.sendMessage("Type " + ChatColor.DARK_AQUA + "/mv import ?" + ChatColor.WHITE + " for help!");
    }

    public void removePlayerSession(Player player) {
        if (this.playerSessions.containsKey(player.getName())) {
            this.playerSessions.remove(player.getName());
        }
    }

    @Override
    public int getPluginCount() {
        return this.pluginCount;
    }

    @Override
    public void incrementPluginCount() {
        ++this.pluginCount;
    }

    @Override
    public void decrementPluginCount() {
        --this.pluginCount;
    }

    @Override
    public AllPay getBanker() {
        return this.banker;
    }

    @Override
    public void setBank(GenericBank bank) {
        this.bank = bank;
    }

    @Override
    public DestinationFactory getDestFactory() {
        return this.destFactory;
    }

    public void teleportPlayer(CommandSender teleporter, Player p, Location l) {
        this.getSafeTTeleporter().safelyTeleport(teleporter, (Entity)p, l, false);
    }

    public File getServerFolder() {
        return this.serverFolder;
    }

    public void setServerFolder(File newServerFolder) {
        if (!newServerFolder.isDirectory()) {
            throw new IllegalArgumentException("That's not a folder!");
        }
        this.serverFolder = newServerFolder;
    }

    @Override
    public MVWorldManager getMVWorldManager() {
        return this.worldManager;
    }

    public MVPlayerListener getPlayerListener() {
        return this.playerListener;
    }

    public MVEntityListener getEntityListener() {
        return this.entityListener;
    }

    public MVWeatherListener getWeatherListener() {
        return this.weatherListener;
    }

    public boolean saveMVConfig() {
        try {
            this.multiverseConfig.set("multiverse-configuration", (Object)this.config);
            this.multiverseConfig.save(new File(this.getDataFolder(), "config.yml"));
            return true;
        }
        catch (IOException e) {
            this.log(Level.SEVERE, "Could not save Multiverse config.yml config. Please check your file permissions.");
            return false;
        }
    }

    public boolean saveWorldConfig() {
        return this.worldManager.saveWorldsConfig();
    }

    @Override
    public boolean saveMVConfigs() {
        return this.saveMVConfig() && this.saveWorldConfig();
    }

    public Boolean deleteWorld(String name) {
        return this.worldManager.deleteWorld(name);
    }

    @Override
    public Boolean regenWorld(String name, Boolean useNewSeed, Boolean randomSeed, String seed) {
        MultiverseWorld world = this.worldManager.getMVWorld(name);
        if (world == null) {
            return false;
        }
        List ps = world.getCBWorld().getPlayers();
        if (useNewSeed.booleanValue()) {
            if (randomSeed.booleanValue()) {
                Random random = new Random();
                Long newseed = random.nextLong();
                seed = newseed.toString();
            }
            ((WorldManager)this.worldManager).getConfigWorlds().set("worlds." + name + ".seed", (Object)seed);
        }
        if (this.worldManager.deleteWorld(name, false)) {
            this.worldManager.loadWorlds(false);
            SafeTTeleporter teleporter = this.getSafeTTeleporter();
            Location newSpawn = this.getServer().getWorld(name).getSpawnLocation();
            for (Player p : ps) {
                teleporter.safelyTeleport(null, (Entity)p, newSpawn, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public AnchorManager getAnchorManager() {
        return this.anchorManager;
    }

    @Override
    public BlockSafety getBlockSafety() {
        return this.blockSafety;
    }

    @Override
    public void setBlockSafety(BlockSafety bs) {
        this.blockSafety = bs;
    }

    @Override
    public LocationManipulation getLocationManipulation() {
        return this.locationManipulation;
    }

    @Override
    public void setLocationManipulation(LocationManipulation locationManipulation) {
        this.locationManipulation = locationManipulation;
    }

    @Override
    public SafeTTeleporter getSafeTTeleporter() {
        return this.safeTTeleporter;
    }

    @Override
    public void setSafeTTeleporter(SafeTTeleporter safeTTeleporter) {
        this.safeTTeleporter = safeTTeleporter;
    }

    @Override
    public MultiverseCoreConfig getMVConfig() {
        return this.config;
    }

    @Deprecated
    public static MultiverseCoreConfiguration getStaticConfig() {
        return MultiverseCoreConfiguration.getInstance();
    }
}

