/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.configuration;

import com.onarandombox.MultiverseCore.configuration.MVActiveConfigProperty;
import org.bukkit.configuration.ConfigurationSection;

public class BooleanConfigProperty
implements MVActiveConfigProperty<Boolean> {
    private String name;
    private Boolean value;
    private String configNode;
    private ConfigurationSection section;
    private String help;
    private String method;

    public BooleanConfigProperty(ConfigurationSection section, String name, Boolean defaultValue, String help) {
        this(section, name, defaultValue, name, help);
    }

    public BooleanConfigProperty(ConfigurationSection section, String name, Boolean defaultValue, String configNode, String help) {
        this.name = name;
        this.configNode = configNode;
        this.section = section;
        this.help = help;
        this.value = defaultValue;
        this.setValue(this.section.getBoolean(this.configNode, defaultValue.booleanValue()));
    }

    public BooleanConfigProperty(ConfigurationSection section, String name, Boolean defaultValue, String configNode, String help, String method) {
        this(section, name, defaultValue, configNode, help);
        this.method = method;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public boolean setValue(Boolean value) {
        if (value == null) {
            return false;
        }
        this.value = value;
        this.section.set(this.configNode, (Object)this.value);
        return true;
    }

    @Override
    public boolean parseValue(String value) {
        if (value == null) {
            return false;
        }
        if (value.toLowerCase().equals("true") || value.toLowerCase().equals("false")) {
            this.setValue(Boolean.parseBoolean(value));
            return true;
        }
        return false;
    }

    @Override
    public String getConfigNode() {
        return this.configNode;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String methodName) {
        this.method = methodName;
    }

    @Override
    public Class<?> getPropertyClass() {
        return Boolean.class;
    }
}

