/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.configuration;

import com.onarandombox.MultiverseCore.configuration.MVActiveConfigProperty;
import org.bukkit.Difficulty;
import org.bukkit.configuration.ConfigurationSection;

public class DifficultyConfigProperty
implements MVActiveConfigProperty<Difficulty> {
    private String name;
    private Difficulty value;
    private String configNode;
    private ConfigurationSection section;
    private String help;

    public DifficultyConfigProperty(ConfigurationSection section, String name, Difficulty defaultValue, String help) {
        this(section, name, defaultValue, name, help);
    }

    public DifficultyConfigProperty(ConfigurationSection section, String name, Difficulty defaultValue, String configNode, String help) {
        this.name = name;
        this.configNode = configNode;
        this.section = section;
        this.help = help;
        this.value = defaultValue;
        this.parseValue(this.section.getString(this.configNode, defaultValue.toString()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Difficulty getValue() {
        return this.value;
    }

    @Override
    public boolean setValue(Difficulty value) {
        if (value == null) {
            return false;
        }
        this.value = value;
        this.section.set(this.configNode, (Object)this.value.toString());
        return true;
    }

    @Override
    public boolean parseValue(String value) {
        try {
            return this.setValue(Difficulty.getByValue((int)Integer.parseInt(value)));
        }
        catch (NumberFormatException nfe) {
            try {
                return this.setValue(Difficulty.valueOf((String)value.toUpperCase()));
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    @Override
    public String getConfigNode() {
        return this.configNode;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public String getMethod() {
        return "setActualDifficulty";
    }

    @Override
    public void setMethod(String methodName) {
    }

    @Override
    public Class<?> getPropertyClass() {
        return Difficulty.class;
    }
}

