/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.configuration;

import com.onarandombox.MultiverseCore.configuration.MVActiveConfigProperty;
import org.bukkit.configuration.ConfigurationSection;

public class DoubleConfigProperty
implements MVActiveConfigProperty<Double> {
    private String name;
    private Double value;
    private String configNode;
    private ConfigurationSection section;
    private String help;
    private String method;

    public DoubleConfigProperty(ConfigurationSection section, String name, Double defaultValue, String help) {
        this(section, name, defaultValue, name, help);
    }

    public DoubleConfigProperty(ConfigurationSection section, String name, Double defaultValue, String configNode, String help) {
        this.name = name;
        this.configNode = configNode;
        this.section = section;
        this.help = help;
        this.value = defaultValue;
        this.setValue(this.section.getDouble(this.configNode, defaultValue.doubleValue()));
    }

    public DoubleConfigProperty(ConfigurationSection section, String name, Double defaultValue, String configNode, String help, String method) {
        this(section, name, defaultValue, configNode, help);
        this.method = method;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public boolean setValue(Double value) {
        if (value == null) {
            return false;
        }
        this.value = value;
        this.section.set(this.configNode, (Object)this.value);
        return true;
    }

    @Override
    public boolean parseValue(String value) {
        try {
            this.setValue(Double.parseDouble(value));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public String getConfigNode() {
        return this.configNode;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String methodName) {
        this.method = methodName;
    }

    @Override
    public Class<?> getPropertyClass() {
        return Double.class;
    }
}

