/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.configuration;

import com.onarandombox.MultiverseCore.configuration.MVActiveConfigProperty;
import com.onarandombox.MultiverseCore.utils.LocationManipulation;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;

public class LocationConfigProperty
implements MVActiveConfigProperty<Location> {
    private String name;
    private Location value;
    private String configNode;
    private ConfigurationSection section;
    private String help;
    private String method;

    public LocationConfigProperty(ConfigurationSection section, String name, Location defaultValue, String help) {
        this(section, name, defaultValue, name, help);
    }

    public LocationConfigProperty(ConfigurationSection section, String name, Location defaultValue, String configNode, String help) {
        this.name = name;
        this.configNode = configNode;
        this.section = section;
        this.help = help;
        this.value = defaultValue;
        this.setValue(this.getLocationFromConfig(defaultValue));
    }

    public LocationConfigProperty(ConfigurationSection section, String name, Location defaultValue, String configNode, String help, String method) {
        this(section, name, defaultValue, configNode, help);
        this.method = method;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Location getValue() {
        return this.value;
    }

    @Override
    public boolean parseValue(String value) {
        Location parsed = LocationManipulation.stringToLocation(value);
        return this.setValue(parsed);
    }

    @Override
    public String getConfigNode() {
        return this.configNode;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    @Override
    public boolean setValue(Location value) {
        if (value == null) {
            return false;
        }
        this.value = value;
        this.section.set(this.configNode + ".x", (Object)this.value.getX());
        this.section.set(this.configNode + ".y", (Object)this.value.getY());
        this.section.set(this.configNode + ".z", (Object)this.value.getZ());
        this.section.set(this.configNode + ".pitch", (Object)Float.valueOf(this.value.getPitch()));
        this.section.set(this.configNode + ".yaw", (Object)Float.valueOf(this.value.getYaw()));
        this.section.set(this.configNode + ".world", (Object)this.value.getWorld().getName());
        return true;
    }

    private Location getLocationFromConfig(Location defaultValue) {
        double x = this.section.getDouble(this.configNode + ".x", defaultValue.getX());
        double y = this.section.getDouble(this.configNode + ".y", defaultValue.getY());
        double z = this.section.getDouble(this.configNode + ".z", defaultValue.getZ());
        double pitch = this.section.getDouble(this.configNode + ".pitch", (double)defaultValue.getPitch());
        double yaw = this.section.getDouble(this.configNode + ".yaw", (double)defaultValue.getYaw());
        String w = this.section.getString(this.configNode + ".world", defaultValue.getWorld().getName());
        Location found = LocationManipulation.stringToLocation(w + ":" + x + "," + y + "," + z + ":" + yaw + ":" + pitch);
        if (found != null) {
            return found;
        }
        return defaultValue;
    }

    @Override
    public String toString() {
        return LocationManipulation.strCoordsRaw(this.value);
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String methodName) {
        this.method = methodName;
    }

    @Override
    public Class<?> getPropertyClass() {
        return Location.class;
    }
}

