/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.configuration;

import com.onarandombox.MultiverseCore.configuration.MVConfigProperty;
import com.onarandombox.MultiverseCore.enums.AllowedPortalType;
import org.bukkit.configuration.ConfigurationSection;

public class PortalTypeConfigProperty
implements MVConfigProperty<AllowedPortalType> {
    private String name;
    private AllowedPortalType value;
    private String configNode;
    private ConfigurationSection section;
    private String help;

    public PortalTypeConfigProperty(ConfigurationSection section, String name, AllowedPortalType defaultValue, String help) {
        this(section, name, defaultValue, name, help);
    }

    public PortalTypeConfigProperty(ConfigurationSection section, String name, AllowedPortalType defaultValue, String configNode, String help) {
        this.name = name;
        this.configNode = configNode;
        this.section = section;
        this.help = help;
        this.value = defaultValue;
        this.parseValue(this.section.getString(this.configNode, defaultValue.toString()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AllowedPortalType getValue() {
        return this.value;
    }

    @Override
    public boolean setValue(AllowedPortalType value) {
        if (value == null) {
            return false;
        }
        this.value = value;
        this.section.set(this.configNode, (Object)this.value.toString());
        return true;
    }

    @Override
    public boolean parseValue(String value) {
        try {
            return this.setValue(AllowedPortalType.valueOf(value.toUpperCase()));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getConfigNode() {
        return this.configNode;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }
}

