/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.configuration;

import com.onarandombox.MultiverseCore.configuration.MVConfigProperty;
import org.bukkit.configuration.ConfigurationSection;

public class StringConfigProperty
implements MVConfigProperty<String> {
    private String name;
    private String value;
    private String configNode;
    private ConfigurationSection section;
    private String help;

    public StringConfigProperty(ConfigurationSection section, String name, String defaultValue, String help) {
        this(section, name, defaultValue, defaultValue, help);
    }

    public StringConfigProperty(ConfigurationSection section, String name, String defaultValue, String configNode, String help) {
        this.name = name;
        this.configNode = configNode;
        this.section = section;
        this.help = help;
        this.value = defaultValue;
        this.parseValue(this.section.getString(this.configNode, defaultValue));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean parseValue(String value) {
        if (value == null) {
            return false;
        }
        this.setValue(value);
        return true;
    }

    @Override
    public String getConfigNode() {
        return this.configNode;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    @Override
    public boolean setValue(String value) {
        if (value == null) {
            return false;
        }
        this.value = value;
        this.section.set(this.configNode, (Object)this.value);
        return true;
    }

    @Override
    public String toString() {
        return this.value;
    }
}

