/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.listeners;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.event.MVRespawnEvent;
import com.onarandombox.MultiverseCore.utils.PermissionTools;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class MVPlayerListener
implements Listener {
    private MultiverseCore plugin;
    private MVWorldManager worldManager;
    private PermissionTools pt;

    public MVPlayerListener(MultiverseCore plugin) {
        this.plugin = plugin;
        this.worldManager = plugin.getMVWorldManager();
        this.pt = new PermissionTools(plugin);
    }

    @EventHandler
    public void playerChat(PlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.plugin.getMVConfig().getPrefixChat()) {
            String world = event.getPlayer().getWorld().getName();
            String prefix = "";
            if (!this.worldManager.isMVWorld(world)) {
                return;
            }
            MultiverseWorld mvworld = this.worldManager.getMVWorld(world);
            if (mvworld.isHidden()) {
                return;
            }
            prefix = mvworld.getColoredWorldString();
            String format = event.getFormat();
            event.setFormat("[" + prefix + "]" + format);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void playerRespawn(PlayerRespawnEvent event) {
        World world = event.getPlayer().getWorld();
        MultiverseWorld mvWorld = this.worldManager.getMVWorld(world.getName());
        if (mvWorld == null) {
            return;
        }
        if (mvWorld.getBedRespawn() && event.isBedSpawn()) {
            this.plugin.log(Level.FINE, "Spawning " + event.getPlayer().getName() + " at their bed");
            return;
        }
        MultiverseWorld respawnWorld = null;
        if (this.worldManager.isMVWorld(mvWorld.getRespawnToWorld())) {
            respawnWorld = this.worldManager.getMVWorld(mvWorld.getRespawnToWorld());
        }
        if (respawnWorld != null) {
            world = respawnWorld.getCBWorld();
        }
        Location respawnLocation = this.getMostAccurateRespawnLocation(world);
        MVRespawnEvent respawnEvent = new MVRespawnEvent(respawnLocation, event.getPlayer(), "compatability");
        this.plugin.getServer().getPluginManager().callEvent((Event)respawnEvent);
        event.setRespawnLocation(respawnEvent.getPlayersRespawnLocation());
    }

    private Location getMostAccurateRespawnLocation(World w) {
        MultiverseWorld mvw = this.worldManager.getMVWorld(w.getName());
        if (mvw != null) {
            return mvw.getSpawnLocation();
        }
        return w.getSpawnLocation();
    }

    @EventHandler
    public void playerJoin(PlayerJoinEvent event) {
        Player p = event.getPlayer();
        if (!p.hasPlayedBefore()) {
            this.plugin.log(Level.FINER, "Player joined for the FIRST time!");
            if (this.plugin.getMVConfig().getFirstSpawnOverride()) {
                this.plugin.log(Level.FINE, String.format("Moving NEW player to(firstspawnoverride): %s", this.worldManager.getFirstSpawnWorld().getSpawnLocation()));
                this.sendPlayerToDefaultWorld(p);
            }
            return;
        }
        this.plugin.log(Level.FINER, "Player joined AGAIN!");
        if (this.plugin.getMVConfig().getEnforceAccess() && !this.plugin.getMVPerms().hasPermission((CommandSender)p, "multiverse.access." + p.getWorld().getName(), false)) {
            p.sendMessage("[MV] - Sorry you can't be in this world anymore!");
            this.sendPlayerToDefaultWorld(p);
        }
        this.handleGameMode(event.getPlayer(), event.getPlayer().getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerChangedWorld(PlayerChangedWorldEvent event) {
        this.handleGameMode(event.getPlayer(), event.getPlayer().getWorld());
    }

    @EventHandler
    public void playerQuit(PlayerQuitEvent event) {
        this.plugin.removePlayerSession(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerTeleport(PlayerTeleportEvent event) {
        this.plugin.log(Level.FINER, String.format("Got teleport event for player '%s' with cause '%s'", event.getPlayer().getName(), event.getCause()));
        if (event.isCancelled()) {
            return;
        }
        Player teleportee = event.getPlayer();
        Player teleporter = null;
        String teleporterName = MultiverseCore.getPlayerTeleporter(teleportee.getName());
        if (teleporterName != null) {
            if (teleporterName.equals("CONSOLE")) {
                this.plugin.log(Level.FINER, "We know the teleporter is the console! Magical!");
                teleporter = this.plugin.getServer().getConsoleSender();
            } else {
                teleporter = this.plugin.getServer().getPlayer(teleporterName);
            }
        }
        this.plugin.log(Level.FINER, String.format("Inferred sender '%s' from name '%s', fetched from name '%s'", teleporter, teleporterName, teleportee.getName()));
        MultiverseWorld fromWorld = this.worldManager.getMVWorld(event.getFrom().getWorld().getName());
        MultiverseWorld toWorld = this.worldManager.getMVWorld(event.getTo().getWorld().getName());
        if (event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            this.plugin.log(Level.FINER, String.format("Player '%s' is teleporting to the same world.", teleportee.getName()));
            this.stateSuccess(teleportee.getName(), toWorld.getAlias());
            return;
        }
        event.setCancelled(!this.pt.playerHasMoneyToEnter(fromWorld, toWorld, (CommandSender)teleporter, teleportee, true));
        if (event.isCancelled() && teleporter != null) {
            this.plugin.log(Level.FINE, String.format("Player '%s' was DENIED ACCESS to '%s' because '%s' don't have the FUNDS required to enter it.", teleportee.getName(), toWorld.getAlias(), teleporter.getName()));
            return;
        }
        if (this.plugin.getMVConfig().getEnforceAccess()) {
            event.setCancelled(!this.pt.playerCanGoFromTo(fromWorld, toWorld, (CommandSender)teleporter, teleportee));
            if (event.isCancelled() && teleporter != null) {
                this.plugin.log(Level.FINE, String.format("Player '%s' was DENIED ACCESS to '%s' because '%s' don't have: multiverse.access.%s", teleportee.getName(), toWorld.getAlias(), teleporter.getName(), event.getTo().getWorld().getName()));
            } else {
                this.stateSuccess(teleportee.getName(), toWorld.getAlias());
            }
        } else {
            this.plugin.log(Level.FINE, String.format("Player '%s' was allowed to go to '%s' because enforceaccess is off.", teleportee.getName(), toWorld.getAlias()));
        }
    }

    private void stateSuccess(String playerName, String worldName) {
        this.plugin.log(Level.FINE, String.format("MV-Core is allowing Player '%s' to go to '%s'.", playerName, worldName));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerPortalCheck(PlayerPortalEvent event) {
        Location newloc;
        if (event.isCancelled() || event.getFrom() == null) {
            return;
        }
        if (event.getFrom().getWorld().getBlockAt(event.getFrom()).getType() != Material.PORTAL && (newloc = this.plugin.getSafeTTeleporter().findPortalBlockNextTo(event.getFrom())) != null) {
            event.setFrom(newloc);
        }
        if (event.getTo() == null) {
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void playerPortal(PlayerPortalEvent event) {
        if (event.isCancelled() || event.getFrom() == null) {
            return;
        }
        if (event.getTo() == null) {
            return;
        }
        MultiverseWorld fromWorld = this.worldManager.getMVWorld(event.getFrom().getWorld().getName());
        MultiverseWorld toWorld = this.worldManager.getMVWorld(event.getTo().getWorld().getName());
        if (event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            this.plugin.log(Level.FINER, "Player '" + event.getPlayer().getName() + "' is portaling to the same world.");
            return;
        }
        event.setCancelled(!this.pt.playerHasMoneyToEnter(fromWorld, toWorld, (CommandSender)event.getPlayer(), event.getPlayer(), true));
        if (event.isCancelled()) {
            this.plugin.log(Level.FINE, String.format("Player '%s' was DENIED ACCESS to '%s' because they don't have the FUNDS required to enter.", event.getPlayer().getName(), event.getTo().getWorld().getName()));
            return;
        }
        if (this.plugin.getMVConfig().getEnforceAccess()) {
            event.setCancelled(!this.pt.playerCanGoFromTo(fromWorld, toWorld, (CommandSender)event.getPlayer(), event.getPlayer()));
            if (event.isCancelled()) {
                this.plugin.log(Level.FINE, String.format("Player '%s' was DENIED ACCESS to '%s' because they don't have: multiverse.access.%s", event.getPlayer().getName(), event.getTo().getWorld().getName(), event.getTo().getWorld().getName()));
            }
        } else {
            this.plugin.log(Level.FINE, String.format("Player '%s' was allowed to go to '%s' because enforceaccess is off.", event.getPlayer().getName(), event.getTo().getWorld().getName()));
        }
    }

    private void sendPlayerToDefaultWorld(final Player player) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                player.teleport(MVPlayerListener.this.plugin.getMVWorldManager().getFirstSpawnWorld().getSpawnLocation());
            }
        }, 1L);
    }

    private void handleGameMode(Player player, World world) {
        MultiverseWorld mvWorld = this.worldManager.getMVWorld(world.getName());
        if (mvWorld != null) {
            this.handleGameMode(player, mvWorld);
        } else {
            this.plugin.log(Level.FINER, String.format("Not handling gamemode for world '%s' not managed by Multiverse.", world.getName()));
        }
    }

    public void handleGameMode(final Player player, final MultiverseWorld world) {
        if (!this.pt.playerCanIgnoreGameModeRestriction(world, player)) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (player.getWorld() == world.getCBWorld()) {
                        MultiverseCore.staticLog(Level.FINE, String.format("Handling gamemode for player: %s, Changing to %s", player.getName(), world.getGameMode().toString()));
                        MultiverseCore.staticLog(Level.FINEST, "From World: " + player.getWorld());
                        MultiverseCore.staticLog(Level.FINEST, "To World: " + world);
                        player.setGameMode(world.getGameMode());
                    } else {
                        MultiverseCore.staticLog(Level.FINE, String.format("The gamemode was NOT changed for player '%s' because he is now in world '%s' instead of world '%s'", player.getName(), player.getWorld().getName(), world.getName()));
                    }
                }
            }, 1L);
        } else {
            this.plugin.log(Level.FINE, String.format("Player: %s is IMMUNE to gamemode changes!", player.getName()));
        }
    }
}

