/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.utils.LocationManipulation;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;

@Deprecated
public class BlockSafety {
    public boolean isBlockAboveAir(Location l) {
        Location downOne = l.clone();
        downOne.setY(downOne.getY() - 1.0);
        return downOne.getBlock().getType() == Material.AIR;
    }

    private boolean blockIsNotSafe(World world, double x, double y, double z) {
        return !this.playerCanSpawnHereSafely(world, x, y, z);
    }

    public boolean playerCanSpawnHereSafely(World world, double x, double y, double z) {
        Location l = new Location(world, x, y, z);
        return this.playerCanSpawnHereSafely(l);
    }

    public boolean playerCanSpawnHereSafely(Location l) {
        if (l == null) {
            return false;
        }
        World world = l.getWorld();
        Location actual = l.clone();
        Location upOne = l.clone();
        Location downOne = l.clone();
        upOne.setY(upOne.getY() + 1.0);
        downOne.setY(downOne.getY() - 1.0);
        if (this.isSolidBlock(world.getBlockAt(actual).getType()) || this.isSolidBlock(upOne.getBlock().getType())) {
            MultiverseCore.staticLog(Level.FINER, "Error Here (Actual)? (" + actual.getBlock().getType() + ")[" + this.isSolidBlock(actual.getBlock().getType()) + "]");
            MultiverseCore.staticLog(Level.FINER, "Error Here (upOne)? (" + upOne.getBlock().getType() + ")[" + this.isSolidBlock(upOne.getBlock().getType()) + "]");
            return false;
        }
        if (downOne.getBlock().getType() == Material.LAVA || downOne.getBlock().getType() == Material.STATIONARY_LAVA) {
            MultiverseCore.staticLog(Level.FINER, "Error Here (downOne)? (" + downOne.getBlock().getType() + ")[" + this.isSolidBlock(downOne.getBlock().getType()) + "]");
            return false;
        }
        if (downOne.getBlock().getType() == Material.FIRE) {
            MultiverseCore.staticLog(Level.FINER, "There's fire below! (" + actual.getBlock().getType() + ")[" + this.isSolidBlock(actual.getBlock().getType()) + "]");
            return false;
        }
        if (this.isBlockAboveAir(actual)) {
            MultiverseCore.staticLog(Level.FINER, "Is block above air [" + this.isBlockAboveAir(actual) + "]");
            MultiverseCore.staticLog(Level.FINER, "Has 2 blocks of water below [" + this.hasTwoBlocksofWaterBelow(actual) + "]");
            return this.hasTwoBlocksofWaterBelow(actual);
        }
        return true;
    }

    public Location getTopBlock(Location l) {
        Location check = l.clone();
        check.setY(127.0);
        while (check.getY() > 0.0) {
            if (this.playerCanSpawnHereSafely(check)) {
                return check;
            }
            check.setY(check.getY() - 1.0);
        }
        return null;
    }

    public Location getBottomBlock(Location l) {
        Location check = l.clone();
        check.setY(0.0);
        while (check.getY() < 127.0) {
            if (this.playerCanSpawnHereSafely(check)) {
                return check;
            }
            check.setY(check.getY() + 1.0);
        }
        return null;
    }

    private boolean isSolidBlock(Material type) {
        switch (type) {
            case AIR: {
                return false;
            }
            case SNOW: {
                return false;
            }
            case TRAP_DOOR: {
                return false;
            }
            case TORCH: {
                return false;
            }
            case YELLOW_FLOWER: {
                return false;
            }
            case RED_ROSE: {
                return false;
            }
            case RED_MUSHROOM: {
                return false;
            }
            case BROWN_MUSHROOM: {
                return false;
            }
            case REDSTONE: {
                return false;
            }
            case REDSTONE_WIRE: {
                return false;
            }
            case RAILS: {
                return false;
            }
            case POWERED_RAIL: {
                return false;
            }
            case REDSTONE_TORCH_ON: {
                return false;
            }
            case REDSTONE_TORCH_OFF: {
                return false;
            }
            case DEAD_BUSH: {
                return false;
            }
            case SAPLING: {
                return false;
            }
            case STONE_BUTTON: {
                return false;
            }
            case LEVER: {
                return false;
            }
            case LONG_GRASS: {
                return false;
            }
            case PORTAL: {
                return false;
            }
            case STONE_PLATE: {
                return false;
            }
            case WOOD_PLATE: {
                return false;
            }
            case SEEDS: {
                return false;
            }
            case SUGAR_CANE_BLOCK: {
                return false;
            }
            case WALL_SIGN: {
                return false;
            }
            case SIGN_POST: {
                return false;
            }
            case WOODEN_DOOR: {
                return false;
            }
            case STATIONARY_WATER: {
                return false;
            }
            case WATER: {
                return false;
            }
        }
        return true;
    }

    public boolean isEntitiyOnTrack(Location l) {
        Material currentBlock = l.getBlock().getType();
        return currentBlock == Material.POWERED_RAIL || currentBlock == Material.DETECTOR_RAIL || currentBlock == Material.RAILS;
    }

    private void showDangers(Location l) {
        Location actual = new Location(l.getWorld(), l.getX(), l.getY(), l.getZ());
        Location upOne = new Location(l.getWorld(), l.getX(), l.getY(), l.getZ());
        Location downOne = new Location(l.getWorld(), l.getX(), l.getY(), l.getZ());
        upOne.setY(upOne.getY() + 1.0);
        downOne.setY(downOne.getY() - 1.0);
        System.out.print("Location Up:   " + upOne.getBlock().getType());
        System.out.print("               " + upOne);
        System.out.print("Location:      " + actual.getBlock().getType());
        System.out.print("               " + actual);
        System.out.print("Location Down: " + downOne.getBlock().getType());
        System.out.print("               " + downOne);
    }

    private boolean hasTwoBlocksofWaterBelow(Location l) {
        if (l.getBlockY() < 0) {
            return false;
        }
        Location oneBelow = l.clone();
        oneBelow.subtract(0.0, 1.0, 0.0);
        if (oneBelow.getBlock().getType() == Material.WATER || oneBelow.getBlock().getType() == Material.STATIONARY_WATER) {
            Location twoBelow = oneBelow.clone();
            twoBelow.subtract(0.0, 1.0, 0.0);
            return oneBelow.getBlock().getType() == Material.WATER || oneBelow.getBlock().getType() == Material.STATIONARY_WATER;
        }
        if (oneBelow.getBlock().getType() != Material.AIR) {
            return false;
        }
        return this.hasTwoBlocksofWaterBelow(oneBelow);
    }

    public boolean canSpawnCartSafely(Minecart cart) {
        if (this.isBlockAboveAir(cart.getLocation())) {
            return true;
        }
        return this.isEntitiyOnTrack(LocationManipulation.getNextBlock((Vehicle)cart));
    }

    public boolean canSpawnVehicleSafely(Vehicle vehicle) {
        return this.isBlockAboveAir(vehicle.getLocation());
    }
}

