/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.api.MultiverseMessaging;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MVMessaging
implements MultiverseMessaging {
    private Map<String, Long> sentList = new HashMap<String, Long>();
    private int cooldown = 5000;

    @Override
    public void setCooldown(int milliseconds) {
        this.cooldown = milliseconds;
    }

    @Override
    public boolean sendMessage(CommandSender sender, String message, boolean ignoreCooldown) {
        return this.sendMessages(sender, new String[]{message}, ignoreCooldown);
    }

    @Override
    public boolean sendMessages(CommandSender sender, String[] messages, boolean ignoreCooldown) {
        if (!(sender instanceof Player) || ignoreCooldown) {
            MVMessaging.sendMessages(sender, messages);
            return true;
        }
        if (!this.sentList.containsKey(sender.getName())) {
            MVMessaging.sendMessages(sender, messages);
            this.sentList.put(sender.getName(), System.currentTimeMillis());
            return true;
        }
        long time = System.currentTimeMillis();
        if (time >= this.sentList.get(sender.getName()) + (long)this.cooldown) {
            MVMessaging.sendMessages(sender, messages);
            this.sentList.put(sender.getName(), System.currentTimeMillis());
            return true;
        }
        return false;
    }

    @Override
    public boolean sendMessages(CommandSender sender, Collection<String> messages, boolean ignoreCooldown) {
        return this.sendMessages(sender, messages.toArray(new String[0]), ignoreCooldown);
    }

    private static void sendMessages(CommandSender sender, String[] messages) {
        for (String s : messages) {
            sender.sendMessage(s);
        }
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }
}

