/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.api.WorldPurger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Squid;

public class SimpleWorldPurger
implements WorldPurger {
    private MultiverseCore plugin;

    public SimpleWorldPurger(MultiverseCore plugin) {
        this.plugin = plugin;
    }

    @Override
    public void purgeWorlds(List<MultiverseWorld> worlds) {
        if (worlds == null || worlds.isEmpty()) {
            return;
        }
        for (MultiverseWorld world : worlds) {
            this.purgeWorld(world);
        }
    }

    @Override
    public void purgeWorld(MultiverseWorld world) {
        if (world == null) {
            return;
        }
        ArrayList<String> allMobs = new ArrayList<String>(world.getAnimalList());
        allMobs.addAll(world.getMonsterList());
        this.purgeWorld(world, allMobs, !world.canAnimalsSpawn(), !world.canMonstersSpawn());
    }

    @Override
    public void purgeWorld(MultiverseWorld mvworld, List<String> thingsToKill, boolean negateAnimals, boolean negateMonsters, CommandSender sender) {
        if (mvworld == null) {
            return;
        }
        World world = mvworld.getCBWorld();
        if (world == null) {
            return;
        }
        int entitiesKilled = 0;
        boolean specifiedAll = thingsToKill.contains("ALL");
        boolean specifiedAnimals = thingsToKill.contains("ANIMALS") || specifiedAll;
        boolean specifiedMonsters = thingsToKill.contains("MONSTERS") || specifiedAll;
        for (Entity e : world.getEntities()) {
            boolean negate = false;
            boolean specified = false;
            if (e instanceof Squid || e instanceof Animals) {
                if (specifiedAnimals && !negateAnimals) {
                    this.plugin.log(Level.FINEST, "Removing an entity because I was told to remove all animals: " + e);
                    e.remove();
                    ++entitiesKilled;
                    continue;
                }
                if (specifiedAnimals) {
                    specified = true;
                }
                negate = negateAnimals;
            } else if (e instanceof Monster || e instanceof Ghast || e instanceof Slime) {
                if (specifiedMonsters && !negateMonsters) {
                    this.plugin.log(Level.FINEST, "Removing an entity because I was told to remove all monsters: " + e);
                    e.remove();
                    ++entitiesKilled;
                    continue;
                }
                if (specifiedMonsters) {
                    specified = true;
                }
                negate = negateMonsters;
            }
            for (String s : thingsToKill) {
                EntityType type = EntityType.fromName((String)s);
                if (type == null || !type.equals((Object)e.getType())) continue;
                specified = true;
                if (negate) break;
                this.plugin.log(Level.FINEST, "Removing an entity because it WAS specified and we are NOT negating: " + e);
                e.remove();
                ++entitiesKilled;
            }
            if (specified || !negate) continue;
            this.plugin.log(Level.FINEST, "Removing an entity because it was NOT specified and we ARE negating: " + e);
            e.remove();
            ++entitiesKilled;
        }
        if (sender != null) {
            sender.sendMessage(entitiesKilled + " entities purged from the world '" + world.getName() + "'");
        }
    }

    @Override
    public void purgeWorld(MultiverseWorld mvworld, List<String> thingsToKill, boolean negateAnimals, boolean negateMonsters) {
        this.purgeWorld(mvworld, thingsToKill, negateAnimals, negateMonsters, null);
    }
}

