/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import java.util.regex.Pattern;

@Deprecated
public class UpdateChecker {
    public static final Logger log = Logger.getLogger("Minecraft");
    private Timer timer = new Timer();
    private String name;
    private String cversion;

    public UpdateChecker(String name, String version) {
        this.name = name;
        this.cversion = version;
        int delay = 0;
        int period = 1800;
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                UpdateChecker.this.checkUpdate();
            }
        }, delay * 1000, (long)(period * 1000));
    }

    public void checkUpdate() {
        try {
            String v2;
            String line;
            URL url = new URL("http://bukkit.onarandombox.com/multiverse/version.php?n=" + URLEncoder.encode(this.name, "UTF-8") + "&v=" + this.cversion);
            URLConnection conn = url.openConnection();
            conn.setReadTimeout(2000);
            int code = ((HttpURLConnection)conn).getResponseCode();
            if (code != 200) {
                return;
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String version = null;
            while ((line = rd.readLine()) != null) {
                if (version != null) continue;
                version = line;
            }
            if (version == null) {
                rd.close();
                return;
            }
            String v1 = UpdateChecker.normalisedVersion(version);
            int compare = v1.compareTo(v2 = UpdateChecker.normalisedVersion(this.cversion));
            if (compare > 0) {
                log.info("[" + this.name + "]" + " - Update Available (" + version + ")");
            }
            rd.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String normalisedVersion(String version) {
        return UpdateChecker.normalisedVersion(version, ".", 4);
    }

    public static String normalisedVersion(String version, String sep, int maxWidth) {
        String[] split = Pattern.compile(sep, 16).split(version);
        StringBuilder sb = new StringBuilder();
        for (String s : split) {
            sb.append(String.format("%" + maxWidth + 's', s));
        }
        return sb.toString();
    }
}

