/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.MVWorld;
import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.api.SafeTTeleporter;
import com.onarandombox.MultiverseCore.api.WorldPurger;
import com.onarandombox.MultiverseCore.commands.EnvironmentCommand;
import com.onarandombox.MultiverseCore.event.MVWorldDeleteEvent;
import com.onarandombox.MultiverseCore.utils.FileUtils;
import com.onarandombox.MultiverseCore.utils.PurgeWorlds;
import com.onarandombox.MultiverseCore.utils.SimpleWorldPurger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

public class WorldManager
implements MVWorldManager {
    private MultiverseCore plugin;
    private WorldPurger worldPurger;
    private Map<String, MultiverseWorld> worlds;
    private List<String> unloadedWorlds;
    private FileConfiguration configWorlds = null;
    private Map<String, String> defaultGens;
    private String firstSpawn;

    public WorldManager(MultiverseCore core) {
        this.plugin = core;
        this.worlds = new HashMap<String, MultiverseWorld>();
        this.unloadedWorlds = new ArrayList<String>();
        this.worldPurger = new SimpleWorldPurger(this.plugin);
    }

    @Override
    public void getDefaultWorldGenerators() {
        this.defaultGens = new HashMap<String, String>();
        File[] files = this.plugin.getServerFolder().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.equalsIgnoreCase("bukkit.yml");
            }
        });
        if (files != null && files.length == 1) {
            YamlConfiguration bukkitConfig = YamlConfiguration.loadConfiguration((File)files[0]);
            if (bukkitConfig.isConfigurationSection("worlds")) {
                Set keys = bukkitConfig.getConfigurationSection("worlds").getKeys(false);
                for (String key : keys) {
                    this.defaultGens.put(key, bukkitConfig.getString("worlds." + key + ".generator", ""));
                }
            }
        } else {
            this.plugin.log(Level.WARNING, "Could not read 'bukkit.yml'. Any Default worldgenerators will not be loaded!");
        }
    }

    @Override
    public boolean addWorld(String name, World.Environment env, String seedString, WorldType type, Boolean generateStructures, String generator) {
        return this.addWorld(name, env, seedString, type, generateStructures, generator, true);
    }

    @Override
    public boolean addWorld(String name, World.Environment env, String seedString, WorldType type, Boolean generateStructures, String generator, boolean useSpawnAdjust) {
        World world;
        Long seed = null;
        WorldCreator c = new WorldCreator(name);
        if (seedString != null && seedString.length() > 0) {
            try {
                seed = Long.parseLong(seedString);
            }
            catch (NumberFormatException numberformatexception) {
                seed = seedString.hashCode();
            }
            c.seed(seed.longValue());
        }
        if (generator != null && generator.length() != 0) {
            c.generator(generator);
        }
        c.environment(env);
        if (type != null) {
            c.type(type);
        }
        if (generateStructures != null) {
            c.generateStructures(generateStructures.booleanValue());
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Loading World & Settings - '").append(name).append("'");
        builder.append(" - Env: ").append(env);
        builder.append(" - Type: ").append(type);
        if (seed != null) {
            builder.append(" & seed: ").append(seed);
        }
        if (generator != null) {
            builder.append(" & generator: ").append(generator);
        }
        this.plugin.log(Level.INFO, builder.toString());
        try {
            world = c.createWorld();
        }
        catch (Exception e) {
            this.plugin.log(Level.SEVERE, "The world '" + name + "' could NOT be loaded because it contains errors!");
            this.plugin.log(Level.SEVERE, "Try using Chukster to repair your world! '" + name + "'");
            this.plugin.log(Level.SEVERE, "http://forums.bukkit.org/threads/admin-chunkster.8186/");
            return false;
        }
        if (world == null) {
            this.plugin.log(Level.SEVERE, "Failed to Create/Load the world '" + name + "'");
            return false;
        }
        MVWorld mvworld = new MVWorld(world, this.configWorlds, this.plugin, this.plugin.getServer().getWorld(name).getSeed(), generator, useSpawnAdjust);
        this.worldPurger.purgeWorld(mvworld);
        this.worlds.put(name, mvworld);
        if (this.unloadedWorlds.contains(name)) {
            this.unloadedWorlds.remove(name);
        }
        return true;
    }

    @Override
    public ChunkGenerator getChunkGenerator(String generator, String generatorID, String worldName) {
        if (generator == null) {
            return null;
        }
        Plugin myPlugin = this.plugin.getServer().getPluginManager().getPlugin(generator);
        if (myPlugin == null) {
            return null;
        }
        return myPlugin.getDefaultWorldGenerator(worldName, generatorID);
    }

    @Override
    public boolean removeWorldFromConfig(String name) {
        if (!this.unloadWorld(name)) {
            return false;
        }
        if (this.configWorlds.get("worlds." + name) != null) {
            this.plugin.log(Level.INFO, "World '" + name + "' was removed from config.yml");
            this.configWorlds.set("worlds." + name, null);
            this.saveWorldsConfig();
            if (this.unloadedWorlds.contains(name)) {
                this.unloadedWorlds.remove(name);
            }
            return true;
        }
        this.plugin.log(Level.INFO, "World '" + name + "' was already removed from config.yml");
        return false;
    }

    @Override
    public void setFirstSpawnWorld(String world) {
        this.firstSpawn = world == null && this.plugin.getServer().getWorlds().size() > 0 ? ((World)this.plugin.getServer().getWorlds().get(0)).getName() : world;
    }

    @Override
    public MultiverseWorld getFirstSpawnWorld() {
        MultiverseWorld world = this.getMVWorld(this.firstSpawn);
        if (world == null) {
            this.plugin.log(Level.WARNING, "The world specified as the spawn world (" + this.firstSpawn + ") did not exist!!");
            try {
                return this.getMVWorld((World)this.plugin.getServer().getWorlds().get(0));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return world;
    }

    @Override
    public boolean unloadWorld(String name) {
        if (this.worlds.containsKey(name)) {
            if (this.unloadWorldFromBukkit(name, true)) {
                this.worlds.remove(name);
                this.plugin.log(Level.INFO, "World '" + name + "' was unloaded from memory.");
                this.unloadedWorlds.add(name);
                return true;
            }
            this.plugin.log(Level.WARNING, "World '" + name + "' could not be unloaded. Is it a default world?");
        } else if (this.plugin.getServer().getWorld(name) != null) {
            this.plugin.log(Level.WARNING, "Hmm Multiverse does not know about this world but it's loaded in memory.");
            this.plugin.log(Level.WARNING, "To unload it using multiverse, use:");
            this.plugin.log(Level.WARNING, "/mv import " + name + " " + this.plugin.getServer().getWorld(name).getEnvironment().toString());
        } else {
            this.plugin.log(Level.INFO, "Multiverse does not know about " + name + " and it's not loaded by Bukkit.");
        }
        return false;
    }

    @Override
    public boolean loadWorld(String name) {
        if (this.worlds.containsKey(name)) {
            if (this.unloadedWorlds.contains(name)) {
                this.unloadedWorlds.remove(name);
            }
            return true;
        }
        Set worldKeys = this.configWorlds.getConfigurationSection("worlds").getKeys(false);
        if (worldKeys != null && worldKeys.contains(name)) {
            String environment = this.configWorlds.getString("worlds." + name + ".environment", "NORMAL");
            String type = this.configWorlds.getString("worlds." + name + ".type", "NORMAL");
            String seedString = this.configWorlds.getString("worlds." + name + ".seed", "");
            String generatorString = this.configWorlds.getString("worlds." + name + ".generator");
            boolean generateStructures = this.configWorlds.getBoolean("worlds." + name + ".generatestructures", true);
            this.addWorld(name, EnvironmentCommand.getEnvFromString(environment), seedString, EnvironmentCommand.getWorldTypeFromString(type), generateStructures, generatorString);
            if (this.unloadedWorlds.contains(name)) {
                this.unloadedWorlds.remove(name);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteWorld(String name, boolean removeFromConfig) {
        World world = this.plugin.getServer().getWorld(name);
        if (world == null) {
            return false;
        }
        MVWorldDeleteEvent mvwde = new MVWorldDeleteEvent(this.getMVWorld(name), removeFromConfig);
        this.plugin.getServer().getPluginManager().callEvent((Event)mvwde);
        if (mvwde.isCancelled()) {
            this.plugin.log(Level.FINE, "Tried to delete a world, but the event was cancelled!");
            return false;
        }
        if (removeFromConfig ? !this.removeWorldFromConfig(name) : !this.unloadWorld(name)) {
            return false;
        }
        try {
            File worldFile = world.getWorldFolder();
            this.plugin.log(Level.FINER, "deleteWorld(): worldFile: " + worldFile.getAbsolutePath());
            boolean deletedWorld = FileUtils.deleteFolder(worldFile);
            if (deletedWorld) {
                this.plugin.log(Level.INFO, "World " + name + " was DELETED.");
            } else {
                this.plugin.log(Level.SEVERE, "World " + name + " was NOT deleted.");
                this.plugin.log(Level.SEVERE, "Are you sure the folder " + name + " exists?");
                this.plugin.log(Level.SEVERE, "Please check your file permissions on " + name);
            }
            return deletedWorld;
        }
        catch (Throwable e) {
            this.plugin.log(Level.SEVERE, "Hrm, something didn't go as planned. Here's an exception for ya.");
            this.plugin.log(Level.SEVERE, "You can go politely explain your situation in #multiverse on esper.net");
            this.plugin.log(Level.SEVERE, "But from here, it looks like your folder is oddly named.");
            this.plugin.log(Level.SEVERE, "This world has been removed from Multiverse-Core so your best bet is to go delete the folder by hand. Sorry.");
            this.plugin.log(Level.SEVERE, e.getMessage());
            return false;
        }
    }

    @Override
    public boolean deleteWorld(String name) {
        return this.deleteWorld(name, true);
    }

    private boolean unloadWorldFromBukkit(String name, boolean safely) {
        this.removePlayersFromWorld(name);
        return this.plugin.getServer().unloadWorld(name, safely);
    }

    @Override
    public void removePlayersFromWorld(String name) {
        World w = this.plugin.getServer().getWorld(name);
        if (w != null) {
            World safeWorld = (World)this.plugin.getServer().getWorlds().get(0);
            List ps = w.getPlayers();
            SafeTTeleporter teleporter = this.plugin.getSafeTTeleporter();
            for (Player p : ps) {
                teleporter.safelyTeleport(null, (Entity)p, safeWorld.getSpawnLocation(), true);
            }
        }
    }

    @Override
    public Collection<MultiverseWorld> getMVWorlds() {
        return this.worlds.values();
    }

    @Override
    public MultiverseWorld getMVWorld(String name) {
        if (this.worlds.containsKey(name)) {
            return this.worlds.get(name);
        }
        return this.getMVWorldByAlias(name);
    }

    @Override
    public MultiverseWorld getMVWorld(World world) {
        if (world != null) {
            return this.getMVWorld(world.getName());
        }
        return null;
    }

    private MultiverseWorld getMVWorldByAlias(String alias) {
        for (MultiverseWorld w : this.worlds.values()) {
            if (!w.getAlias().equalsIgnoreCase(alias)) continue;
            return w;
        }
        return null;
    }

    @Override
    public boolean isMVWorld(String name) {
        return this.worlds.containsKey(name) || this.isMVWorldAlias(name);
    }

    @Override
    public boolean isMVWorld(World world) {
        return world != null && this.isMVWorld(world.getName());
    }

    private boolean isMVWorldAlias(String alias) {
        for (MultiverseWorld w : this.worlds.values()) {
            if (!w.getAlias().equalsIgnoreCase(alias)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loadDefaultWorlds() {
        this.ensureConfigIsPrepared();
        List myWorlds = this.plugin.getServer().getWorlds();
        Set worldStrings = this.configWorlds.getConfigurationSection("worlds").getKeys(false);
        for (World w : myWorlds) {
            String name = w.getName();
            if (worldStrings.contains(name)) continue;
            if (this.defaultGens.containsKey(name)) {
                this.addWorld(name, w.getEnvironment(), w.getSeed() + "", w.getWorldType(), w.canGenerateStructures(), this.defaultGens.get(name));
                continue;
            }
            this.addWorld(name, w.getEnvironment(), w.getSeed() + "", w.getWorldType(), w.canGenerateStructures(), null);
        }
    }

    private void ensureConfigIsPrepared() {
        if (this.configWorlds.getConfigurationSection("worlds") == null) {
            this.configWorlds.createSection("worlds");
            try {
                this.configWorlds.save(new File(this.plugin.getDataFolder(), "worlds.yml"));
            }
            catch (IOException e) {
                this.plugin.log(Level.SEVERE, "Failed to save worlds.yml. Please check your file permissions.");
            }
        }
    }

    @Override
    public void loadWorlds(boolean forceLoad) {
        int count = 0;
        this.ensureConfigIsPrepared();
        this.ensureSecondNamespaceIsPrepared();
        Set worldKeys = this.configWorlds.getConfigurationSection("worlds").getKeys(false);
        if (forceLoad) {
            Permission allAccess = this.plugin.getServer().getPluginManager().getPermission("multiverse.access.*");
            Permission allExempt = this.plugin.getServer().getPluginManager().getPermission("multiverse.exempt.*");
            for (MultiverseWorld w : this.worlds.values()) {
                if (allAccess != null) {
                    allAccess.getChildren().remove(w.getAccessPermission().getName());
                }
                if (allExempt != null) {
                    allExempt.getChildren().remove(w.getAccessPermission().getName());
                }
                this.plugin.getServer().getPluginManager().removePermission(w.getAccessPermission().getName());
                this.plugin.getServer().getPluginManager().removePermission(w.getExemptPermission().getName());
                this.plugin.getServer().getPluginManager().removePermission("mv.bypass.gamemode." + w.getName());
            }
            this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(allAccess);
            this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(allExempt);
            this.worlds.clear();
        }
        if (worldKeys != null) {
            for (String worldKey : worldKeys) {
                if (this.worlds.containsKey(worldKey)) continue;
                if (!this.configWorlds.getBoolean("worlds." + worldKey + ".autoload", true)) {
                    if (this.unloadedWorlds.contains(worldKey)) continue;
                    this.unloadedWorlds.add(worldKey);
                    continue;
                }
                String environment = this.configWorlds.getString("worlds." + worldKey + ".environment", "NORMAL");
                String type = this.configWorlds.getString("worlds." + worldKey + ".type", "NORMAL");
                String seedString = this.configWorlds.getString("worlds." + worldKey + ".seed", null);
                boolean generateStructures = this.configWorlds.getBoolean("worlds." + worldKey + ".generatestructures", true);
                if (seedString == null) {
                    seedString = this.configWorlds.getLong("worlds." + worldKey + ".seed") + "";
                }
                String generatorString = this.configWorlds.getString("worlds." + worldKey + ".generator");
                if (environment.equalsIgnoreCase("skylands")) {
                    this.plugin.log(Level.WARNING, "Found SKYLANDS world. Not importing automatically, as it won't work atm :(");
                    continue;
                }
                this.addWorld(worldKey, EnvironmentCommand.getEnvFromString(environment), seedString, EnvironmentCommand.getWorldTypeFromString(type), generateStructures, generatorString);
                ++count;
            }
        }
        this.plugin.log(Level.INFO, count + " - World(s) loaded.");
    }

    private void ensureSecondNamespaceIsPrepared() {
        Permission special = this.plugin.getServer().getPluginManager().getPermission("mv.bypass.gamemode.*");
        if (special == null) {
            special = new Permission("mv.bypass.gamemode.*", PermissionDefault.FALSE);
            this.plugin.getServer().getPluginManager().addPermission(special);
        }
    }

    @Override
    @Deprecated
    public PurgeWorlds getWorldPurger() {
        return new PurgeWorlds(this.plugin);
    }

    @Override
    public WorldPurger getTheWorldPurger() {
        return this.worldPurger;
    }

    @Override
    public FileConfiguration loadWorldConfig(File file) {
        this.configWorlds = YamlConfiguration.loadConfiguration((File)file);
        return this.configWorlds;
    }

    @Override
    public boolean saveWorldsConfig() {
        try {
            this.configWorlds.save(new File(this.plugin.getDataFolder(), "worlds.yml"));
            return true;
        }
        catch (IOException e) {
            this.plugin.log(Level.SEVERE, "Could not save worlds.yml. Please check your settings.");
            return false;
        }
    }

    @Override
    public MultiverseWorld getSpawnWorld() {
        return this.getMVWorld((World)this.plugin.getServer().getWorlds().get(0));
    }

    @Override
    public List<String> getUnloadedWorlds() {
        return this.unloadedWorlds;
    }

    public FileConfiguration getConfigWorlds() {
        return this.configWorlds;
    }
}

