/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils.webpaste;

import com.onarandombox.MultiverseCore.utils.webpaste.PasteFailedException;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PastiePasteService
implements PasteService {
    private boolean isPrivate;

    public PastiePasteService(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    @Override
    public URL getPostURL() {
        try {
            return new URL("http://pastie.org/pastes");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String encodeData(String data) {
        try {
            String encData = URLEncoder.encode("paste[authorization]", "UTF-8") + "=" + URLEncoder.encode("burger", "UTF-8");
            encData = encData + "&" + URLEncoder.encode("paste[restricted]", "UTF-8") + "=" + URLEncoder.encode(this.isPrivate ? "1" : "0", "UTF-8");
            encData = encData + "&" + URLEncoder.encode("paste[parser_id]", "UTF-8") + "=" + URLEncoder.encode("6", "UTF-8");
            encData = encData + "&" + URLEncoder.encode("paste[body]", "UTF-8") + "=" + URLEncoder.encode(data, "UTF-8");
            return encData;
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    @Override
    public String postData(String encodedData, URL url) throws PasteFailedException {
        try {
            String line;
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(encodedData);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String pastieUrl = "";
            Pattern pastiePattern = this.getURLMatchingPattern();
            while ((line = rd.readLine()) != null) {
                Matcher m = pastiePattern.matcher(line);
                if (!m.matches()) continue;
                String pastieID = m.group(1);
                pastieUrl = this.formatURL(pastieID);
            }
            wr.close();
            rd.close();
            return pastieUrl;
        }
        catch (Exception e) {
            throw new PasteFailedException(e);
        }
    }

    private Pattern getURLMatchingPattern() {
        if (this.isPrivate) {
            return Pattern.compile(".*http://pastie.org/.*key=([0-9a-z]+).*");
        }
        return Pattern.compile(".*http://pastie.org/([0-9]+).*");
    }

    private String formatURL(String pastieID) {
        return "http://pastie.org/" + (this.isPrivate ? "private/" : "") + pastieID;
    }
}

