/*
 * Decompiled with CFR 0.152.
 */
package me.main__.util.multiverse.SerializationConfig;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import me.main__.util.multiverse.SerializationConfig.ChangeDeniedException;
import me.main__.util.multiverse.SerializationConfig.IllegalPropertyValueException;
import me.main__.util.multiverse.SerializationConfig.InstanceCache;
import me.main__.util.multiverse.SerializationConfig.MissingAnnotationException;
import me.main__.util.multiverse.SerializationConfig.NoSuchPropertyException;
import me.main__.util.multiverse.SerializationConfig.ObjectUsingValidator;
import me.main__.util.multiverse.SerializationConfig.Property;
import me.main__.util.multiverse.SerializationConfig.ReflectionUtils;
import me.main__.util.multiverse.SerializationConfig.Serializor;
import me.main__.util.multiverse.SerializationConfig.ValidateAllWith;
import me.main__.util.multiverse.SerializationConfig.Validator;
import me.main__.util.multiverse.SerializationConfig.VirtualProperty;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public abstract class SerializationConfig
implements ConfigurationSerializable {
    private static final InstanceCache<Serializor<?, ?>> serializorCache = new InstanceCache();
    private static final InstanceCache<Validator<?>> validatorCache = new InstanceCache();

    public SerializationConfig() {
        this.setDefaults();
    }

    public static void registerAll(Class<? extends SerializationConfig> clazz) {
        Field[] fields;
        ConfigurationSerialization.registerClass(clazz);
        for (Field f : fields = clazz.getDeclaredFields()) {
            Class<?> fieldclazz;
            f.setAccessible(true);
            if (f.isAnnotationPresent(Property.class) && ConfigurationSerializable.class.isAssignableFrom(fieldclazz = f.getType())) {
                Class<ConfigurationSerializable> subclass = fieldclazz.asSubclass(ConfigurationSerializable.class);
                ConfigurationSerialization.registerClass(subclass);
            }
            f.setAccessible(false);
        }
    }

    public static void unregisterAll(Class<? extends SerializationConfig> clazz) {
        Field[] fields;
        ConfigurationSerialization.unregisterClass(clazz);
        for (Field f : fields = clazz.getDeclaredFields()) {
            Class<?> fieldclazz;
            f.setAccessible(true);
            if (f.isAnnotationPresent(Property.class) && ConfigurationSerializable.class.isAssignableFrom(fieldclazz = f.getType())) {
                Class<ConfigurationSerializable> subclass = fieldclazz.asSubclass(ConfigurationSerializable.class);
                ConfigurationSerialization.unregisterClass(subclass);
            }
            f.setAccessible(false);
        }
    }

    public SerializationConfig(Map<String, Object> values) {
        this();
        Field[] fields;
        for (Field f : fields = this.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            if (f.isAnnotationPresent(Property.class) && !VirtualProperty.class.isAssignableFrom(f.getType())) {
                try {
                    Property propertyInfo = f.getAnnotation(Property.class);
                    Class<? extends Serializor> serializorClass = propertyInfo.serializor();
                    Serializor serializor = serializorCache.getInstance(serializorClass, this);
                    Object value = serializor.deserialize(values.get(f.getName()), f.getType());
                    if (value == null) continue;
                    f.set(this, value);
                }
                catch (Exception e) {}
                continue;
            }
            f.setAccessible(false);
        }
    }

    public final Map<String, Object> serialize() {
        Field[] fields = this.getClass().getDeclaredFields();
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (Field f : fields) {
            f.setAccessible(true);
            if (f.isAnnotationPresent(Property.class) && !VirtualProperty.class.isAssignableFrom(f.getType())) {
                try {
                    Property propertyInfo = f.getAnnotation(Property.class);
                    Class<? extends Serializor> serializorClass = propertyInfo.serializor();
                    Serializor serializor = serializorCache.getInstance(serializorClass, this);
                    ret.put(f.getName(), serializor.serialize(f.get(this)));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            f.setAccessible(false);
        }
        return ret;
    }

    public final boolean setPropertyValue(String property, Object value) throws ClassCastException {
        return this.setPropertyValue(property, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean setPropertyValue(String property, Object value, boolean ignoreCase) throws ClassCastException {
        try {
            String[] nodes = property.split("\\.");
            if (nodes.length == 1) {
                Field field = null;
                try {
                    field = ReflectionUtils.getField(nodes[0], this.getClass(), ignoreCase);
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(Property.class)) {
                        if (!(field.getType().isAssignableFrom(value.getClass()) || field.getType().isPrimitive() || VirtualProperty.class.isAssignableFrom(field.getType()))) {
                            throw new ClassCastException(value.getClass().toString() + " cannot be cast to " + field.getType().toString());
                        }
                        Property propertyInfo = field.getAnnotation(Property.class);
                        if (!VirtualProperty.class.isAssignableFrom(field.getType())) {
                            boolean vProp = this.validateAndDoChange(field, value);
                            return vProp;
                        }
                        try {
                            value = this.validate(field, propertyInfo, value);
                        }
                        catch (ChangeDeniedException e) {
                            boolean bl = false;
                            if (field == null) return bl;
                            field.setAccessible(false);
                            return bl;
                        }
                        VirtualProperty vProp = (VirtualProperty)field.get(this);
                        vProp.set(value);
                        boolean bl = true;
                        return bl;
                    }
                    throw new MissingAnnotationException("Property");
                }
                catch (MissingAnnotationException e) {
                    throw new NoSuchPropertyException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new NoSuchPropertyException(e);
                }
                catch (ClassCastException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    boolean vProp = false;
                    return vProp;
                }
                finally {
                    if (field != null) {
                        field.setAccessible(false);
                    }
                }
            }
            String nextNode = nodes[0];
            Field nodeField = ReflectionUtils.getField(nextNode, this.getClass(), ignoreCase);
            nodeField.setAccessible(true);
            if (!nodeField.isAnnotationPresent(Property.class)) {
                throw new Exception();
            }
            SerializationConfig child = (SerializationConfig)nodeField.get(this);
            StringBuilder sb = new StringBuilder();
            int i = 1;
            while (true) {
                if (i >= nodes.length) {
                    sb.deleteCharAt(sb.length() - 1);
                    return child.setPropertyValue(sb.toString(), value, ignoreCase);
                }
                sb.append(nodes[i]).append('.');
                ++i;
            }
        }
        catch (ClassCastException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean setProperty(String property, String value) {
        return this.setProperty(property, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public final boolean setProperty(String property, String value, boolean ignoreCase) {
        try {
            String[] nodes = property.split("\\.");
            if (nodes.length == 1) {
                Field field = null;
                try {
                    field = ReflectionUtils.getField(nodes[0], this.getClass(), ignoreCase);
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(Property.class)) {
                        Object oVal;
                        Property propertyInfo = field.getAnnotation(Property.class);
                        Class<? extends Serializor> serializorClass = propertyInfo.serializor();
                        Serializor serializor = serializorCache.getInstance(serializorClass, this);
                        try {
                            oVal = serializor.deserialize(value, field.getType());
                        }
                        catch (IllegalPropertyValueException e) {
                            boolean bl = false;
                            if (field != null) {
                                field.setAccessible(false);
                            }
                            return bl;
                        }
                        catch (RuntimeException e) {
                            boolean bl = false;
                            if (field != null) {
                                field.setAccessible(false);
                            }
                            return bl;
                        }
                        if (VirtualProperty.class.isAssignableFrom(field.getType())) {
                            try {
                                oVal = this.validate(field, propertyInfo, oVal);
                            }
                            catch (ChangeDeniedException e) {
                                boolean bl = false;
                                if (field != null) {
                                    field.setAccessible(false);
                                }
                                return bl;
                            }
                            VirtualProperty vProp = (VirtualProperty)field.get(this);
                            vProp.set(oVal);
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = this.validateAndDoChange(field, oVal);
                        return bl;
                    }
                    throw new MissingAnnotationException("Property");
                    {
                        catch (MissingAnnotationException e) {
                            throw new NoSuchPropertyException(e);
                        }
                        catch (NoSuchFieldException e) {
                            throw new NoSuchPropertyException(e);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            boolean serializorClass = false;
                            return serializorClass;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (field != null) {
                        field.setAccessible(false);
                    }
                }
            }
            String nextNode = nodes[0];
            Field nodeField = ReflectionUtils.getField(nextNode, this.getClass(), ignoreCase);
            nodeField.setAccessible(true);
            if (!nodeField.isAnnotationPresent(Property.class)) {
                throw new Exception();
            }
            SerializationConfig child = (SerializationConfig)nodeField.get(this);
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < nodes.length; ++i) {
                sb.append(nodes[i]).append('.');
            }
            sb.deleteCharAt(sb.length() - 1);
            return child.setProperty(sb.toString(), value, ignoreCase);
        }
        catch (Exception e) {
            return false;
        }
    }

    private Object validate(Field field, Property propertyInfo, Object newVal) throws IllegalAccessException, ChangeDeniedException {
        Validator validator = null;
        if (propertyInfo.validator() != Validator.class) {
            validator = validatorCache.getInstance(propertyInfo.validator(), this);
        } else if (this.getClass().isAnnotationPresent(ValidateAllWith.class)) {
            ValidateAllWith validAll = this.getClass().getAnnotation(ValidateAllWith.class);
            validator = validatorCache.getInstance(validAll.value(), this);
        }
        if (validator != null) {
            try {
                newVal = validator instanceof ObjectUsingValidator ? ((ObjectUsingValidator)validator).validateChange(field.getName(), newVal, field.get(this), this) : validator.validateChange(field.getName(), newVal, field.get(this));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Illegal validator!", e);
            }
        }
        return newVal;
    }

    private <T> boolean validateAndDoChange(Field field, T newVal) throws Exception {
        if (!field.getType().isAssignableFrom(newVal.getClass()) && !field.getType().isPrimitive()) {
            return false;
        }
        Property propInfo = field.getAnnotation(Property.class);
        try {
            newVal = this.validate(field, propInfo, newVal);
        }
        catch (ChangeDeniedException e) {
            return false;
        }
        field.set(this, newVal);
        return true;
    }

    protected abstract void setDefaults();
}

