/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.antibuild;

import com.earth2me.essentials.antibuild.AntiBuildConfig;
import com.earth2me.essentials.antibuild.EssentialsAntiBuildListener;
import com.earth2me.essentials.antibuild.EssentialsConnect;
import com.earth2me.essentials.antibuild.IAntiBuild;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class EssentialsAntiBuild
extends JavaPlugin
implements IAntiBuild {
    private static final Logger LOGGER = Logger.getLogger("Minecraft");
    private final transient Map<AntiBuildConfig, Boolean> settingsBoolean = new EnumMap<AntiBuildConfig, Boolean>(AntiBuildConfig.class);
    private final transient Map<AntiBuildConfig, List<Integer>> settingsList = new EnumMap<AntiBuildConfig, List<Integer>>(AntiBuildConfig.class);
    private transient EssentialsConnect ess = null;

    public void onEnable() {
        PluginManager pm = this.getServer().getPluginManager();
        Plugin essPlugin = pm.getPlugin("Essentials");
        if (essPlugin == null || !essPlugin.isEnabled()) {
            return;
        }
        this.ess = new EssentialsConnect(essPlugin, this);
        EssentialsAntiBuildListener blockListener = new EssentialsAntiBuildListener(this);
        pm.registerEvents((Listener)blockListener, (Plugin)this);
    }

    @Override
    public boolean checkProtectionItems(AntiBuildConfig list, int id) {
        List<Integer> itemList = this.settingsList.get((Object)list);
        return itemList != null && !itemList.isEmpty() && itemList.contains(id);
    }

    @Override
    public EssentialsConnect getEssentialsConnect() {
        return this.ess;
    }

    @Override
    public Map<AntiBuildConfig, Boolean> getSettingsBoolean() {
        return this.settingsBoolean;
    }

    @Override
    public Map<AntiBuildConfig, List<Integer>> getSettingsList() {
        return this.settingsList;
    }

    @Override
    public boolean getSettingBool(AntiBuildConfig protectConfig) {
        Boolean bool = this.settingsBoolean.get((Object)protectConfig);
        return bool == null ? protectConfig.getDefaultValueBoolean() : bool.booleanValue();
    }
}

