/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.internal.Constants;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.minecraft.server.v1_6_R3.BiomeBase;
import net.minecraft.server.v1_6_R3.Block;
import net.minecraft.server.v1_6_R3.EntityTypes;
import net.minecraft.server.v1_6_R3.NBTBase;
import net.minecraft.server.v1_6_R3.NBTTagByte;
import net.minecraft.server.v1_6_R3.NBTTagByteArray;
import net.minecraft.server.v1_6_R3.NBTTagCompound;
import net.minecraft.server.v1_6_R3.NBTTagDouble;
import net.minecraft.server.v1_6_R3.NBTTagEnd;
import net.minecraft.server.v1_6_R3.NBTTagFloat;
import net.minecraft.server.v1_6_R3.NBTTagInt;
import net.minecraft.server.v1_6_R3.NBTTagIntArray;
import net.minecraft.server.v1_6_R3.NBTTagList;
import net.minecraft.server.v1_6_R3.NBTTagLong;
import net.minecraft.server.v1_6_R3.NBTTagShort;
import net.minecraft.server.v1_6_R3.NBTTagString;
import net.minecraft.server.v1_6_R3.TileEntity;
import net.minecraft.server.v1_6_R3.World;
import net.minecraft.server.v1_6_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_6_R3.CraftServer;
import org.bukkit.craftbukkit.v1_6_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_6_R3.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;

public final class CraftBukkit_v1_6_R3
implements BukkitImplAdapter {
    private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private final Field nbtListTagListField;
    private final Method nbtCreateTagMethod;

    public CraftBukkit_v1_6_R3() throws NoSuchFieldException, NoSuchMethodException {
        CraftServer.class.cast(Bukkit.getServer());
        this.nbtListTagListField = NBTTagList.class.getDeclaredField("list");
        this.nbtListTagListField.setAccessible(true);
        this.nbtCreateTagMethod = NBTBase.class.getDeclaredMethod("createTag", Byte.TYPE);
        this.nbtCreateTagMethod.setAccessible(true);
    }

    private static Block getBlockFromTypeId(int type) {
        if (type >= 0 && type < 4096) {
            return Block.byId[type];
        }
        return null;
    }

    private static void readTagIntoTileEntity(NBTTagCompound tag, TileEntity tileEntity) {
        tileEntity.a(tag);
    }

    private static void readTileEntityIntoTag(TileEntity tileEntity, NBTTagCompound tag) {
        tileEntity.b(tag);
    }

    @Nullable
    private static String getEntityId(net.minecraft.server.v1_6_R3.Entity entity) {
        return EntityTypes.b((net.minecraft.server.v1_6_R3.Entity)entity);
    }

    @Nullable
    private static net.minecraft.server.v1_6_R3.Entity createEntityFromId(String id, World world) {
        return EntityTypes.createEntityByName((String)id, (World)world);
    }

    private static void readTagIntoEntity(NBTTagCompound tag, net.minecraft.server.v1_6_R3.Entity entity) {
        entity.f(tag);
    }

    private static void readEntityIntoTag(net.minecraft.server.v1_6_R3.Entity entity, NBTTagCompound tag) {
        entity.e(tag);
    }

    @Override
    public int getBlockId(Material material) {
        return material.getId();
    }

    @Override
    public Material getMaterial(int id) {
        return Material.getMaterial((int)id);
    }

    @Override
    public int getBiomeId(Biome biome) {
        BiomeBase mcBiome = CraftBlock.biomeToBiomeBase((Biome)biome);
        return mcBiome != null ? mcBiome.id : 0;
    }

    @Override
    public Biome getBiome(int id) {
        if (id >= 0 && id < BiomeBase.biomes.length) {
            BiomeBase mcBiome = BiomeBase.biomes[id];
            return CraftBlock.biomeBaseToBiome((BiomeBase)mcBiome);
        }
        return null;
    }

    @Override
    public BaseBlock getBlock(Location location) {
        Preconditions.checkNotNull((Object)location);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        org.bukkit.block.Block bukkitBlock = location.getBlock();
        BaseBlock block = new BaseBlock(bukkitBlock.getTypeId(), bukkitBlock.getData());
        TileEntity te = craftWorld.getHandle().getTileEntity(x, y, z);
        if (te != null) {
            NBTTagCompound tag = new NBTTagCompound();
            CraftBukkit_v1_6_R3.readTileEntityIntoTag(te, tag);
            block.setNbtData((CompoundTag)this.toNative((NBTBase)tag));
        }
        return block;
    }

    @Override
    public boolean setBlock(Location location, BaseBlock block, boolean notifyAndLight) {
        TileEntity tileEntity;
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)block);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        boolean changed = craftWorld.getHandle().setTypeIdAndData(x, y, z, block.getId(), block.getData(), 0);
        CompoundTag nativeTag = block.getNbtData();
        if (nativeTag != null && (tileEntity = craftWorld.getHandle().getTileEntity(x, y, z)) != null) {
            NBTTagCompound tag = (NBTTagCompound)this.fromNative("", nativeTag);
            tag.set("x", (NBTBase)new NBTTagInt("x", x));
            tag.set("y", (NBTBase)new NBTTagInt("y", y));
            tag.set("z", (NBTBase)new NBTTagInt("z", z));
            CraftBukkit_v1_6_R3.readTagIntoTileEntity(tag, tileEntity);
        }
        boolean bl = changed = craftWorld.getHandle().setData(x, y, z, block.getData(), 0) || changed;
        if (changed && notifyAndLight) {
            craftWorld.getHandle().notify(x, y, z);
            craftWorld.getHandle().update(x, y, z, block.getId());
        }
        return changed;
    }

    @Override
    public BaseEntity getEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        CraftEntity craftEntity = (CraftEntity)entity;
        net.minecraft.server.v1_6_R3.Entity mcEntity = craftEntity.getHandle();
        String id = CraftBukkit_v1_6_R3.getEntityId(mcEntity);
        if (id != null) {
            NBTTagCompound tag = new NBTTagCompound();
            CraftBukkit_v1_6_R3.readEntityIntoTag(mcEntity, tag);
            return new BaseEntity(id, (CompoundTag)this.toNative((NBTBase)tag));
        }
        return null;
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity state) {
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)state);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        WorldServer worldServer = craftWorld.getHandle();
        net.minecraft.server.v1_6_R3.Entity createdEntity = CraftBukkit_v1_6_R3.createEntityFromId(state.getTypeId(), (World)craftWorld.getHandle());
        if (createdEntity != null) {
            CompoundTag nativeTag = state.getNbtData();
            if (nativeTag != null) {
                NBTTagCompound tag = (NBTTagCompound)this.fromNative(state.getTypeId(), nativeTag);
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.remove(name);
                }
                CraftBukkit_v1_6_R3.readTagIntoEntity(tag, createdEntity);
            }
            createdEntity.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            worldServer.addEntity(createdEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            return createdEntity.getBukkitEntity();
        }
        return null;
    }

    private static String getTagName(int i) {
        switch (i) {
            case 0: {
                return "TAG_End";
            }
            case 1: {
                return "TAG_Byte";
            }
            case 2: {
                return "TAG_Short";
            }
            case 3: {
                return "TAG_Int";
            }
            case 4: {
                return "TAG_Long";
            }
            case 5: {
                return "TAG_Float";
            }
            case 6: {
                return "TAG_Double";
            }
            case 7: {
                return "TAG_Byte_Array";
            }
            case 8: {
                return "TAG_String";
            }
            case 9: {
                return "TAG_List";
            }
            case 10: {
                return "TAG_Compound";
            }
            case 11: {
                return "TAG_Int_Array";
            }
            case 99: {
                return "Any Numeric Tag";
            }
        }
        return "UNKNOWN";
    }

    private Tag toNative(NBTBase foreign) {
        return this.toNative(CraftBukkit_v1_6_R3.getTagName(foreign.getTypeId()), foreign);
    }

    private Tag toNative(String name, NBTBase foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof NBTTagCompound) {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            Collection foreignKeys = ((NBTTagCompound)foreign).c();
            for (Object obj : foreignKeys) {
                String key = (String)obj;
                NBTBase base = ((NBTTagCompound)foreign).get(key);
                values.put(key, this.toNative(key, base));
            }
            return new CompoundTag(values);
        }
        if (foreign instanceof NBTTagByte) {
            return new ByteTag(((NBTTagByte)foreign).data);
        }
        if (foreign instanceof NBTTagByteArray) {
            return new ByteArrayTag(((NBTTagByteArray)foreign).data);
        }
        if (foreign instanceof NBTTagDouble) {
            return new DoubleTag(((NBTTagDouble)foreign).data);
        }
        if (foreign instanceof NBTTagFloat) {
            return new FloatTag(((NBTTagFloat)foreign).data);
        }
        if (foreign instanceof NBTTagInt) {
            return new IntTag(((NBTTagInt)foreign).data);
        }
        if (foreign instanceof NBTTagIntArray) {
            return new IntArrayTag(((NBTTagIntArray)foreign).data);
        }
        if (foreign instanceof NBTTagList) {
            try {
                return this.toNative((NBTTagList)foreign);
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Failed to convert NBTTagList", e);
                return new ListTag(ByteTag.class, new ArrayList());
            }
        }
        if (foreign instanceof NBTTagLong) {
            return new LongTag(((NBTTagLong)foreign).data);
        }
        if (foreign instanceof NBTTagShort) {
            return new ShortTag(((NBTTagShort)foreign).data);
        }
        if (foreign instanceof NBTTagString) {
            return new StringTag(((NBTTagString)foreign).data);
        }
        if (foreign instanceof NBTTagEnd) {
            return new EndTag();
        }
        throw new IllegalArgumentException("Don't know how to make native " + foreign.getClass().getCanonicalName());
    }

    private ListTag toNative(NBTTagList foreign) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ArrayList<Tag> values = new ArrayList<Tag>();
        List foreignList = (List)this.nbtListTagListField.get(foreign);
        Class cls = StringTag.class;
        for (int i = 0; i < foreign.size(); ++i) {
            NBTBase element = (NBTBase)foreignList.get(i);
            Tag tag = this.toNative(null, element);
            values.add(tag);
            cls = tag.getClass();
        }
        return new ListTag(cls, values);
    }

    private NBTBase fromNative(String name, Tag foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof CompoundTag) {
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry entry : ((CompoundTag)foreign).getValue().entrySet()) {
                tag.set((String)entry.getKey(), this.fromNative((String)entry.getKey(), (Tag)entry.getValue()));
            }
            return tag;
        }
        if (foreign instanceof ByteTag) {
            return new NBTTagByte(name, ((ByteTag)foreign).getValue().byteValue());
        }
        if (foreign instanceof ByteArrayTag) {
            return new NBTTagByteArray(name, ((ByteArrayTag)foreign).getValue());
        }
        if (foreign instanceof DoubleTag) {
            return new NBTTagDouble(name, ((DoubleTag)foreign).getValue().doubleValue());
        }
        if (foreign instanceof FloatTag) {
            return new NBTTagFloat(name, ((FloatTag)foreign).getValue().floatValue());
        }
        if (foreign instanceof IntTag) {
            return new NBTTagInt(name, ((IntTag)foreign).getValue().intValue());
        }
        if (foreign instanceof IntArrayTag) {
            return new NBTTagIntArray(name, ((IntArrayTag)foreign).getValue());
        }
        if (foreign instanceof ListTag) {
            NBTTagList tag = new NBTTagList();
            ListTag foreignList = (ListTag)foreign;
            Iterator iterator = foreignList.getValue().iterator();
            while (iterator.hasNext()) {
                Tag t = (Tag)iterator.next();
                tag.add(this.fromNative("", t));
            }
            return tag;
        }
        if (foreign instanceof LongTag) {
            return new NBTTagLong(name, ((LongTag)foreign).getValue().longValue());
        }
        if (foreign instanceof ShortTag) {
            return new NBTTagShort(name, ((ShortTag)foreign).getValue().shortValue());
        }
        if (foreign instanceof StringTag) {
            return new NBTTagString(((StringTag)foreign).getValue());
        }
        if (foreign instanceof EndTag) {
            try {
                return (NBTBase)this.nbtCreateTagMethod.invoke(null, (byte)0);
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new IllegalArgumentException("Don't know how to make NMS " + foreign.getClass().getCanonicalName());
    }
}

