/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.MetaItemStack;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.craftbukkit.InventoryWorkaround;
import com.earth2me.essentials.textreader.KeywordReplacer;
import com.earth2me.essentials.textreader.SimpleTextInput;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.NumberUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import net.ess3.api.IEssentials;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Kit {
    final IEssentials ess;
    final String kitName;
    final Map<String, Object> kit;
    final Trade charge;

    public Kit(String kitName, IEssentials ess) throws Exception {
        this.kitName = kitName;
        this.ess = ess;
        this.kit = ess.getSettings().getKit(kitName);
        this.charge = new Trade("kit-" + kitName, new Trade("kit-kit", ess), ess);
        if (this.kit == null) {
            throw new Exception(I18n.tl("kitNotFound", new Object[0]));
        }
    }

    public static String listKits(IEssentials ess, User user) throws Exception {
        try {
            ConfigurationSection kits = ess.getSettings().getKits();
            StringBuilder list = new StringBuilder();
            for (String kitItem : kits.getKeys(false)) {
                Kit kit;
                if (user == null) {
                    list.append(" ").append(I18n.capitalCase(kitItem));
                    continue;
                }
                if (!user.isAuthorized("essentials.kits." + kitItem.toLowerCase(Locale.ENGLISH))) continue;
                String cost = "";
                String name = I18n.capitalCase(kitItem);
                BigDecimal costPrice = new Trade("kit-" + kitItem.toLowerCase(Locale.ENGLISH), ess).getCommandCost(user);
                if (costPrice.signum() > 0) {
                    cost = I18n.tl("kitCost", NumberUtil.displayCurrency(costPrice, ess));
                }
                if ((kit = new Kit(kitItem, ess)).getNextUse(user) != 0L) {
                    name = I18n.tl("kitDelay", name);
                }
                list.append(" ").append(name).append(cost);
            }
            return list.toString().trim();
        }
        catch (Exception ex) {
            throw new Exception(I18n.tl("kitError", new Object[0]), ex);
        }
    }

    public String getName() {
        return this.kitName;
    }

    public void checkPerms(User user) throws Exception {
        if (!user.isAuthorized("essentials.kits." + this.kitName)) {
            throw new Exception(I18n.tl("noKitPermission", "essentials.kits." + this.kitName));
        }
    }

    public void checkDelay(User user) throws Exception {
        long nextUse = this.getNextUse(user);
        if (nextUse == 0L) {
            return;
        }
        if (nextUse < 0L) {
            user.sendMessage(I18n.tl("kitOnce", new Object[0]));
            throw new NoChargeException();
        }
        user.sendMessage(I18n.tl("kitTimed", DateUtil.formatDateDiff(nextUse)));
        throw new NoChargeException();
    }

    public void checkAffordable(User user) throws Exception {
        this.charge.isAffordableFor(user);
    }

    public void setTime(User user) throws Exception {
        GregorianCalendar time = new GregorianCalendar();
        user.setKitTimestamp(this.kitName, time.getTimeInMillis());
    }

    public void chargeUser(User user) throws Exception {
        this.charge.charge(user);
    }

    public long getNextUse(User user) throws Exception {
        if (user.isAuthorized("essentials.kit.exemptdelay")) {
            return 0L;
        }
        GregorianCalendar time = new GregorianCalendar();
        double delay = 0.0;
        try {
            delay = this.kit.containsKey("delay") ? ((Number)this.kit.get("delay")).doubleValue() : 0.0;
        }
        catch (Exception e) {
            throw new Exception(I18n.tl("kitError2", new Object[0]));
        }
        long lastTime = user.getKitTimestamp(this.kitName);
        GregorianCalendar delayTime = new GregorianCalendar();
        delayTime.setTimeInMillis(lastTime);
        ((Calendar)delayTime).add(13, (int)delay);
        ((Calendar)delayTime).add(14, (int)(delay * 1000.0 % 1000.0));
        if (lastTime == 0L || lastTime > time.getTimeInMillis()) {
            return 0L;
        }
        if (delay < 0.0) {
            return -1L;
        }
        if (delayTime.before(time)) {
            return 0L;
        }
        return delayTime.getTimeInMillis();
    }

    public List<String> getItems(User user) throws Exception {
        if (this.kit == null) {
            throw new Exception(I18n.tl("kitNotFound", new Object[0]));
        }
        try {
            ArrayList<String> itemList = new ArrayList<String>();
            Object kitItems = this.kit.get("items");
            if (kitItems instanceof List) {
                for (Object item : (List)kitItems) {
                    if (item instanceof String) {
                        itemList.add(item.toString());
                        continue;
                    }
                    throw new Exception("Invalid kit item: " + item.toString());
                }
                return itemList;
            }
            throw new Exception("Invalid item list");
        }
        catch (Exception e) {
            this.ess.getLogger().log(Level.WARNING, "Error parsing kit " + this.kitName + ": " + e.getMessage());
            throw new Exception(I18n.tl("kitError2", new Object[0]), e);
        }
    }

    public void expandItems(User user) throws Exception {
        this.expandItems(user, this.getItems(user));
    }

    public void expandItems(User user, List<String> items) throws Exception {
        try {
            SimpleTextInput input = new SimpleTextInput(items);
            KeywordReplacer output = new KeywordReplacer(input, user.getSource(), this.ess);
            boolean spew = false;
            boolean allowUnsafe = this.ess.getSettings().allowUnsafeEnchantments();
            for (String kitItem : output.getLines()) {
                boolean allowOversizedStacks;
                if (kitItem.startsWith(this.ess.getSettings().getCurrencySymbol())) {
                    BigDecimal value = new BigDecimal(kitItem.substring(this.ess.getSettings().getCurrencySymbol().length()).trim());
                    Trade t = new Trade(value, this.ess);
                    t.pay(user, Trade.OverflowType.DROP);
                    continue;
                }
                String[] parts = kitItem.split(" +");
                ItemStack parseStack = this.ess.getItemDb().get(parts[0], parts.length > 1 ? Integer.parseInt(parts[1]) : 1);
                if (parseStack.getType() == Material.AIR) continue;
                MetaItemStack metaStack = new MetaItemStack(parseStack);
                if (parts.length > 2) {
                    metaStack.parseStringMeta(null, allowUnsafe, parts, 2, this.ess);
                }
                Map<Integer, ItemStack> overfilled = (allowOversizedStacks = user.isAuthorized("essentials.oversizedstacks")) ? InventoryWorkaround.addOversizedItems((Inventory)user.getBase().getInventory(), this.ess.getSettings().getOversizedStackSize(), metaStack.getItemStack()) : InventoryWorkaround.addItems((Inventory)user.getBase().getInventory(), metaStack.getItemStack());
                for (ItemStack itemStack : overfilled.values()) {
                    int spillAmount = itemStack.getAmount();
                    if (!allowOversizedStacks) {
                        itemStack.setAmount(spillAmount < itemStack.getMaxStackSize() ? spillAmount : itemStack.getMaxStackSize());
                    }
                    while (spillAmount > 0) {
                        user.getWorld().dropItemNaturally(user.getLocation(), itemStack);
                        spillAmount -= itemStack.getAmount();
                    }
                    spew = true;
                }
            }
            user.getBase().updateInventory();
            if (spew) {
                user.sendMessage(I18n.tl("kitInvFull", new Object[0]));
            }
        }
        catch (Exception e) {
            user.getBase().updateInventory();
            this.ess.getLogger().log(Level.WARNING, e.getMessage());
            throw new Exception(I18n.tl("kitError2", new Object[0]), e);
        }
    }
}

