/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.ess3.api.IEssentials;
import org.bukkit.Bukkit;

public class UUIDMap {
    private final transient IEssentials ess;
    private File userList;
    private final transient Pattern splitPattern = Pattern.compile(",");
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    private final AtomicInteger pendingDiskWrites = new AtomicInteger(0);

    public UUIDMap(IEssentials ess) {
        this.ess = ess;
        this.userList = new File(ess.getDataFolder(), "usermap.csv");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllUsers(ConcurrentSkipListMap<String, UUID> names, ConcurrentSkipListMap<UUID, ArrayList<String>> history) {
        try {
            if (!this.userList.exists()) {
                this.userList.createNewFile();
            }
            AtomicInteger atomicInteger = this.pendingDiskWrites;
            synchronized (atomicInteger) {
                if (this.ess.getSettings().isDebug()) {
                    this.ess.getLogger().log(Level.INFO, "Reading usermap from disk");
                }
                names.clear();
                history.clear();
                BufferedReader reader = new BufferedReader(new FileReader(this.userList));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        ArrayList<Object> list;
                        String[] values = this.splitPattern.split(line);
                        if (values.length != 2) continue;
                        String name = values[0];
                        UUID uuid = UUID.fromString(values[1]);
                        names.put(name, uuid);
                        if (!history.containsKey(uuid)) {
                            list = new ArrayList<String>();
                            list.add(name);
                            history.put(uuid, list);
                            continue;
                        }
                        list = history.get(uuid);
                        if (list.contains(name)) continue;
                        list.add(name);
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void writeUUIDMap() {
        this._writeUUIDMap();
    }

    public void forceWriteUUIDMap() {
        if (this.ess.getSettings().isDebug()) {
            this.ess.getLogger().log(Level.INFO, "Forcing usermap write to disk");
        }
        try {
            Future<?> future = this._writeUUIDMap();
            if (future != null) {
                future.get();
            }
        }
        catch (InterruptedException ex) {
            this.ess.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (ExecutionException ex) {
            this.ess.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public Future<?> _writeUUIDMap() {
        ConcurrentSkipListMap<String, UUID> names = this.ess.getUserMap().getNames();
        if (names.size() < 1) {
            return null;
        }
        this.pendingDiskWrites.incrementAndGet();
        Future<?> future = EXECUTOR_SERVICE.submit(new WriteRunner(this.ess.getDataFolder(), this.userList, names, this.pendingDiskWrites));
        return future;
    }

    private static class WriteRunner
    implements Runnable {
        private final File location;
        private final File endFile;
        private final ConcurrentSkipListMap<String, UUID> names;
        private final AtomicInteger pendingDiskWrites;

        private WriteRunner(File location, File endFile, ConcurrentSkipListMap<String, UUID> names, AtomicInteger pendingDiskWrites) {
            this.location = location;
            this.endFile = endFile;
            this.names = names;
            this.pendingDiskWrites = pendingDiskWrites;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AtomicInteger atomicInteger = this.pendingDiskWrites;
            synchronized (atomicInteger) {
                if (this.pendingDiskWrites.get() > 1) {
                    this.pendingDiskWrites.decrementAndGet();
                    return;
                }
                File configFile = null;
                try {
                    configFile = File.createTempFile("usermap", ".tmp.csv", this.location);
                    BufferedWriter bWriter = new BufferedWriter(new FileWriter(configFile));
                    for (Map.Entry<String, UUID> entry : this.names.entrySet()) {
                        bWriter.write(entry.getKey() + "," + entry.getValue().toString());
                        bWriter.newLine();
                    }
                    bWriter.close();
                    Files.move((File)configFile, (File)this.endFile);
                }
                catch (IOException ex) {
                    try {
                        if (configFile != null && configFile.exists()) {
                            Files.move((File)configFile, (File)new File(this.endFile.getParentFile(), "usermap.bak.csv"));
                        }
                    }
                    catch (Exception ex2) {
                        Bukkit.getLogger().log(Level.SEVERE, ex2.getMessage(), ex2);
                    }
                    Bukkit.getLogger().log(Level.WARNING, ex.getMessage(), ex);
                }
                finally {
                    this.pendingDiskWrites.decrementAndGet();
                }
            }
        }
    }
}

