/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.logging.Level;
import org.bukkit.BanList;
import org.bukkit.Server;

public class Commandbanip
extends EssentialsCommand {
    public Commandbanip() {
        super("banip");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        String ipAddress;
        String senderName;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        String string = senderName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : "Console";
        if (FormatUtil.validIP(args[0])) {
            ipAddress = args[0];
        } else {
            try {
                User player = this.getPlayer(server, args, 0, true, true);
                ipAddress = player.getLastLoginAddress();
            }
            catch (PlayerNotFoundException ex) {
                ipAddress = args[0];
            }
        }
        if (ipAddress.isEmpty()) {
            throw new PlayerNotFoundException();
        }
        String banReason = args.length > 1 ? FormatUtil.replaceFormat(Commandbanip.getFinalArg(args, 1).replace("\\n", "\n").replace("|", "\n")) : I18n.tl("defaultBanReason", new Object[0]);
        this.ess.getServer().getBanList(BanList.Type.IP).addBan(ipAddress, banReason, null, senderName);
        server.getLogger().log(Level.INFO, I18n.tl("playerBanIpAddress", senderName, ipAddress, banReason));
        this.ess.broadcastMessage("essentials.ban.notify", I18n.tl("playerBanIpAddress", senderName, ipAddress, banReason));
    }
}

