/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.DateUtil;
import org.bukkit.Server;

public class Commandtogglejail
extends EssentialsCommand {
    public Commandtogglejail() {
        super("togglejail");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User player = this.getPlayer(server, args, 0, true, true);
        if (args.length >= 2 && !player.isJailed()) {
            if (!player.getBase().isOnline()) {
                if (sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.togglejail.offline")) {
                    sender.sendMessage(I18n.tl("mayNotJailOffline", new Object[0]));
                    return;
                }
            } else if (player.isAuthorized("essentials.jail.exempt")) {
                sender.sendMessage(I18n.tl("mayNotJail", new Object[0]));
                return;
            }
            if (player.getBase().isOnline()) {
                this.ess.getJails().sendToJail(player, args[1]);
            } else {
                this.ess.getJails().getJail(args[1]);
            }
            player.setJailed(true);
            player.sendMessage(I18n.tl("userJailed", new Object[0]));
            player.setJail(null);
            player.setJail(args[1]);
            long timeDiff = 0L;
            if (args.length > 2) {
                String time = Commandtogglejail.getFinalArg(args, 2);
                timeDiff = DateUtil.parseDateDiff(time, true);
                player.setJailTimeout(timeDiff);
            }
            sender.sendMessage(timeDiff > 0L ? I18n.tl("playerJailedFor", player.getName(), DateUtil.formatDateDiff(timeDiff)) : I18n.tl("playerJailed", player.getName()));
            return;
        }
        if (args.length >= 2 && player.isJailed() && !args[1].equalsIgnoreCase(player.getJail())) {
            sender.sendMessage(I18n.tl("jailAlreadyIncarcerated", player.getJail()));
            return;
        }
        if (args.length >= 2 && player.isJailed() && args[1].equalsIgnoreCase(player.getJail())) {
            String time = Commandtogglejail.getFinalArg(args, 2);
            long timeDiff = DateUtil.parseDateDiff(time, true);
            player.setJailTimeout(timeDiff);
            sender.sendMessage(I18n.tl("jailSentenceExtended", DateUtil.formatDateDiff(timeDiff)));
            return;
        }
        if (args.length == 1 || args.length == 2 && args[1].equalsIgnoreCase(player.getJail())) {
            if (!player.isJailed()) {
                throw new NotEnoughArgumentsException();
            }
            player.setJailed(false);
            player.setJailTimeout(0L);
            player.sendMessage(I18n.tl("jailReleasedPlayerNotify", new Object[0]));
            player.setJail(null);
            if (player.getBase().isOnline()) {
                player.getTeleport().back();
            }
            sender.sendMessage(I18n.tl("jailReleased", player.getName()));
        }
    }
}

