/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.chat;

import com.earth2me.essentials.User;
import com.earth2me.essentials.chat.ChatStore;
import com.earth2me.essentials.chat.EssentialsChatPlayer;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Locale;
import java.util.Map;
import net.ess3.api.IEssentials;
import net.ess3.api.IUser;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.scoreboard.Team;

public class EssentialsChatPlayerListenerLowest
extends EssentialsChatPlayer {
    public EssentialsChatPlayerListenerLowest(Server server, IEssentials ess, Map<AsyncPlayerChatEvent, ChatStore> chatStorage) {
        super(server, ess, chatStorage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (this.isAborted(event)) {
            return;
        }
        User user = this.ess.getUser(event.getPlayer());
        if (user == null) {
            event.setCancelled(true);
            return;
        }
        ChatStore chatStore = new ChatStore(this.ess, user, this.getChatType(event.getMessage()));
        this.setChatStore(event, chatStore);
        event.setMessage(FormatUtil.formatMessage((IUser)user, (String)"essentials.chat", (String)event.getMessage()));
        String group = user.getGroup();
        String world = user.getWorld().getName();
        Team team = user.getBase().getScoreboard().getPlayerTeam((OfflinePlayer)user.getBase());
        String format = this.ess.getSettings().getChatFormat(group);
        format = format.replace("{0}", group);
        format = format.replace("{1}", world);
        format = format.replace("{2}", world.substring(0, 1).toUpperCase(Locale.ENGLISH));
        format = format.replace("{3}", team == null ? "" : team.getPrefix());
        format = format.replace("{4}", team == null ? "" : team.getSuffix());
        String string = format = format.replace("{5}", team == null ? "" : team.getDisplayName());
        synchronized (string) {
            event.setFormat(format);
        }
    }
}

