/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.spawn;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.Kit;
import com.earth2me.essentials.OfflinePlayer;
import com.earth2me.essentials.User;
import com.earth2me.essentials.spawn.SpawnStorage;
import com.earth2me.essentials.textreader.IText;
import com.earth2me.essentials.textreader.KeywordReplacer;
import com.earth2me.essentials.textreader.SimpleTextPager;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class EssentialsSpawnPlayerListener
implements Listener {
    private static final Logger LOGGER = Bukkit.getLogger();
    private final transient IEssentials ess;
    private final transient SpawnStorage spawns;

    public EssentialsSpawnPlayerListener(IEssentials ess, SpawnStorage spawns) {
        this.ess = ess;
        this.spawns = spawns;
    }

    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Location bed;
        Location home;
        User user = this.ess.getUser(event.getPlayer());
        if (user.isJailed() && user.getJail() != null && !user.getJail().isEmpty()) {
            return;
        }
        if (this.ess.getSettings().getRespawnAtHome() && (home = (bed = user.getBase().getBedSpawnLocation()) != null ? bed : user.getHome(user.getLocation())) != null) {
            event.setRespawnLocation(home);
            return;
        }
        Location spawn = this.spawns.getSpawn(user.getGroup());
        if (spawn != null) {
            event.setRespawnLocation(spawn);
        }
    }

    public void onPlayerJoin(final PlayerJoinEvent event) {
        this.ess.runTaskAsynchronously(new Runnable(){

            @Override
            public void run() {
                EssentialsSpawnPlayerListener.this.delayedJoin(event.getPlayer());
            }
        });
    }

    public void delayedJoin(Player player) {
        if (player.hasPlayedBefore()) {
            LOGGER.log(Level.FINE, "Old player join");
            return;
        }
        final User user = this.ess.getUser(player);
        if (!"none".equalsIgnoreCase(this.ess.getSettings().getNewbieSpawn())) {
            this.ess.scheduleSyncDelayedTask((Runnable)new NewPlayerTeleport(user), 1L);
        }
        this.ess.scheduleSyncDelayedTask(new Runnable(){

            @Override
            public void run() {
                String kitName;
                if (!user.getBase().isOnline()) {
                    return;
                }
                if (EssentialsSpawnPlayerListener.this.ess.getSettings().getAnnounceNewPlayers()) {
                    KeywordReplacer output = new KeywordReplacer(EssentialsSpawnPlayerListener.this.ess.getSettings().getAnnounceNewPlayerFormat(), user.getSource(), EssentialsSpawnPlayerListener.this.ess);
                    SimpleTextPager pager = new SimpleTextPager((IText)output);
                    for (String line : pager.getLines()) {
                        EssentialsSpawnPlayerListener.this.ess.broadcastMessage((IUser)user, line);
                    }
                }
                if (!(kitName = EssentialsSpawnPlayerListener.this.ess.getSettings().getNewPlayerKit()).isEmpty()) {
                    try {
                        Kit kit = new Kit(kitName.toLowerCase(Locale.ENGLISH), EssentialsSpawnPlayerListener.this.ess);
                        kit.expandItems(user);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, ex.getMessage());
                    }
                }
                LOGGER.log(Level.FINE, "New player join");
            }
        }, 2L);
    }

    private class NewPlayerTeleport
    implements Runnable {
        private final transient User user;

        public NewPlayerTeleport(User user) {
            this.user = user;
        }

        @Override
        public void run() {
            if (this.user.getBase() instanceof OfflinePlayer || !this.user.getBase().isOnline()) {
                return;
            }
            try {
                Location spawn = EssentialsSpawnPlayerListener.this.spawns.getSpawn(EssentialsSpawnPlayerListener.this.ess.getSettings().getNewbieSpawn());
                if (spawn != null) {
                    this.user.getTeleport().now(spawn, false, PlayerTeleportEvent.TeleportCause.PLUGIN);
                }
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, I18n.tl((String)"teleportNewPlayerError", (Object[])new Object[0]), ex);
            }
        }
    }
}

