/**
 * oEditor - object editor
 *
 * @author Fafu <fafu.rb@gmail.com>
 * @version 2.0
 */

const cOrange = 0xFF9900AA; 
local objList = [];
dofile("scripts/oEditorObjectsList.nut", true);
objList = loadObjects();
local objects = {};
local pData = {};
dofile("scripts/easyini.nut");

function onPlayerConnect(playerid) {
	pData[playerid] <- {};
	pData[playerid].currentObj <- -1;
	pData[playerid].keys <- false;
	pData[playerid].keysRotation <- false;
	pData[playerid].keysDistance <- 0.5;
	pData[playerid].listVisible <- false;
	pData[playerid].loopGeneratorVisible <- false;
	pData[playerid].editObjectVisible <- false;
	pData[playerid].magicCarpetVisible <- false;
	pData[playerid].magicCarpetTimer <- null;
	pData[playerid].magicCarpetObjID <- -1;
	pData[playerid].moveTimer <- null;
	pData[playerid].generatedObjects <- {};
	pData[playerid].logged <- false;
	local users = EasyINI("scripts/oEditorUsers.ini");
	sendPlayerMessage(playerid, "This server is using oEditor by Fafu."+(users.keyExists("Users", getPlayerName(playerid)) ? " Type /oh to see commands." : ""), cOrange);
	if(users.keyExists("Users", getPlayerName(playerid))) {
		sendPlayerMessage(playerid, "You can build on this server. Type /ologin [password] to sign in.", cOrange);
	}
}
addEvent("playerConnect", onPlayerConnect);

function onPlayerDisconnect(playerid, reason) {
	delete pData[playerid];
}
addEvent("playerDisconnect", onPlayerDisconnect);

function onScriptInit() {
	loadClientScript("oEditorClient.nut");
	if(objList.len() > 0) {
		log("Loaded oEditorObjectsList.nut ("+objList.len()+")");
	}
	//generateLoop(0, 123, 1234.0, 4321.0, 123.0, 15, 0, 50, 0.0, 0.0, 90.0, "x", 0.1, 90.0);
}
addEvent("scriptInit", onScriptInit);

function onScriptExit() {
	unloadClientScript("oEditorClient.nut");
}
addEvent("scriptExit", onScriptExit);

function onPlayerCommand(playerid, command) {
	local cmd = split(command, " ");
	if(cmd[0] == "/ologin") {
		local users = EasyINI("scripts/oEditorUsers.ini");
		if(users.keyExists("Users", getPlayerName(playerid))) {
			if(users.getKey("Users", getPlayerName(playerid)) == md5(cmd[1])) {
				pData[playerid].logged = true;
				sendPlayerMessage(playerid, "You have been logged.", cOrange);
			} else {
				sendPlayerMessage(playerid, "Specified password is incorrect.", cOrange);
			}
		} else {
			sendPlayerMessage(playerid, "You don't have an account.", cOrange);
		}
		return 1;
	}
	if(!pData[playerid].logged) return;
	switch(cmd[0].slice(1)) {
		case "oh":
			sendPlayerMessage(playerid, "/oc [0-"+(objList.len()-1)+"] - create object, /ocp, /ocpp - duplicate object, /od - delete object", cOrange);
			sendPlayerMessage(playerid, "/os [objID] - select object, /ox [amount], /oz [amount], /oy [amount] - move object", cOrange);
			sendPlayerMessage(playerid, "/orx [amount], /ory [amount], /orz [amount] - rotate object, /ot - toggle keys ", cOrange);
			sendPlayerMessage(playerid, "/ota [amount] - keys distance, [W:X+] [S:X-] [D:Y+] [A:Y-] [UP:Z+] [DOWN:Z-] [R:toggle rotation]", cOrange);
			sendPlayerMessage(playerid, "/osave [name] - save objects, /oload [name] - load objects, /oclear - detele all objects", cOrange);
			sendPlayerMessage(playerid, "/ocm [objID1] [objID2] [amount] - create multiple objects, /oloop - toggle loop generator", cOrange);
			sendPlayerMessage(playerid, "/osel - toggle object list, /osearch [name] - search object, /oedit - edit object", cOrange);
			sendPlayerMessage(playerid, "/opassword [password] - set password, /oadduser [playerid] - add user, /oremoveuser [playerid] - remove user", cOrange);
			sendPlayerMessage(playerid, "/omc - toggle magic carpet", cOrange);
			return 1;
		break;
		
		case "opassword":
			local users = EasyINI("scripts/oEditorUsers.ini");
			users.setKey("Users", name, md5(cmd[1]));
			sendPlayerMessage(playerid, "Your password has been changed.", cOrange);
			return 1;
		break;
		
		case "oadduser":
			local users = EasyINI("scripts/oEditorUsers.ini");
			local id = cmd[1].tointeger();
			local name = getPlayerName(id);
			if(!users.keyExists("Users", name)) {
				users.setKey("Users", name, "no_password");
				sendPlayerMessage(playerid, "Player "+name+" has been added.", cOrange);
				sendPlayerMessage(id, "You have been added to the users by "+getPlayerName(playerid)+". Type /opassword [password] to change your password.", cOrange);
				pData[id].logged = true;
			} else {
				sendPlayerMessage(playerid, "Player "+name+" already has an account.", cOrange);
			}
			return 1;
		break;
		
		case "oadduser":
			local users = EasyINI("scripts/oEditorUsers.ini");
			local id = cmd[1].tointeger();
			local name = getPlayerName(id);
			if(users.keyExists("Users", name)) {
				users.deleteKey("Users", name);
				sendPlayerMessage(playerid, "Player "+name+" has been removed.", cOrange);
				sendPlayerMessage(id, "You have been removed from the users by "+getPlayerName(playerid)+".", cOrange);
				pData[id].logged = false;
			} else {
				sendPlayerMessage(playerid, "Player "+name+" doesn't has an account.", cOrange);
			}
			return 1;
		break;
		
		case "omc":
			pData[playerid].magicCarpetVisible = !pData[playerid].magicCarpetVisible;
			sendPlayerMessage(playerid, "Magic Carpet turned "+(pData[playerid].magicCarpetVisible ? "on" : "off")+".", cOrange);
			if(pData[playerid].magicCarpetVisible) {
				pData[playerid].magicCarpetObjID = createObject(0x4F3E5681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
				pData[playerid].magicCarpetTimer = timer(updateMagicCarpet, 100, -1, playerid);
			} else {
				if(pData[playerid].magicCarpetTimer != null) {
					if(pData[playerid].magicCarpetTimer.isActive()) {
						pData[playerid].magicCarpetTimer.kill();
						pData[playerid].magicCarpetTimer = null;
						deleteObject(pData[playerid].magicCarpetObjID);
						pData[playerid].magicCarpetObjID = -1;
					}
				}
			}
			return 1;
		break;
		
		case "osel":
			triggerClientEvent(playerid, "toggleObjectList", !pData[playerid].listVisible);
			togglePlayerControls(playerid, pData[playerid].listVisible);
			pData[playerid].listVisible = !pData[playerid].listVisible;
			return 1;
		break;
		
		case "oloop":
			triggerClientEvent(playerid, "toggleLoopGenerator", !pData[playerid].loopGeneratorVisible, pData[playerid].currentObj);
			togglePlayerControls(playerid, pData[playerid].loopGeneratorVisible);
			pData[playerid].loopGeneratorVisible = !pData[playerid].loopGeneratorVisible;
			return 1;
		break;
		
		case "oedit":
			if(pData[playerid].currentObj < 0) {
				sendPlayerMessage(playerid, "You need to select object: /os [objID]", cOrange);
			} else {
				triggerClientEvent(playerid, "toggleEditObject", !pData[playerid].editObjectVisible, objects[pData[playerid].currentObj]);
				togglePlayerControls(playerid, pData[playerid].editObjectVisible);
				pData[playerid].editObjectVisible = !pData[playerid].editObjectVisible;
			}
			return 1;
		break;
		
		case "ot":
			pData[playerid].keys = !pData[playerid].keys;
			togglePlayerFrozen(playerid, pData[playerid].keys);
			sendPlayerMessage(playerid, (pData[playerid].keys ? "Keys enabled." : "Keys disabled."), cOrange);
			return 1;
		break;
		
		case "ota":
			pData[playerid].keysDistance = cmd[1].tofloat();
			return 1;
		break;
		
		case "oc":
			local pos = getCoordinatesInFrontOfPlayer(playerid, 5.0);
			pData[playerid].currentObj = createObject(objList[cmd[1].tointeger()][0], pos[0], pos[1], pos[2], 0.0, 0.0, 0.0);
			objects[pData[playerid].currentObj] <- [objList[cmd[1].tointeger()][0], pos[0], pos[1], pos[2], 0.0, 0.0, 0.0];
			sendPlayerMessage(playerid, "Object created (#"+pData[playerid].currentObj+") [0x"+format("%X", objList[cmd[1].tointeger()][0])+" - "+objList[cmd[1].tointeger()][1]+"]", cOrange);
			return 1;
		break;
			
		case "ocp":
			local obj = objects[pData[playerid].currentObj];
			pData[playerid].currentObj = createObject(obj[0], obj[1], obj[2], obj[3], obj[4], obj[5], obj[6]);
			objects[pData[playerid].currentObj] <- [obj[0], obj[1], obj[2], obj[3], obj[4], obj[5], obj[6]];
			sendPlayerMessage(playerid, "Object duplicated [0x"+format("%X", obj[0])+"] (#"+pData[playerid].currentObj+")", cOrange);
			return 1;
		break;
			
		case "ocpp":
			local pos = getCoordinatesInFrontOfPlayer(playerid, 5.0);
			local obj = objects[pData[playerid].currentObj];
			pData[playerid].currentObj = createObject(obj[0], pos[0], pos[1], pos[2], obj[4], obj[5], obj[6]);
			objects[pData[playerid].currentObj] <- [obj[0], pos[0], pos[1], pos[2], obj[4], obj[5], obj[6]];
			sendPlayerMessage(playerid, "Object duplicated at your position [0x"+format("%X", obj[0])+"] (#"+pData[playerid].currentObj+")", cOrange);
			return 1;
		break;
		
		case "ocm":
			local obj1 = objects[cmd[1].tointeger()];
			local obj2 = objects[cmd[2].tointeger()];
			local dist = [(obj1[1]-obj2[1]), (obj1[2]-obj2[2]), (obj1[3]-obj2[3])];
			local obj = obj1;
			for(local i = 0; i < cmd[3].tointeger(); i++) {
				pData[playerid].currentObj = createObject(obj[0], obj[1]+dist[0], obj[2]+dist[1], obj[3]+dist[2], obj[4], obj[5], obj[6]);
				objects[pData[playerid].currentObj] <- [obj[0], obj[1]+dist[0], obj[2]+dist[1], obj[3]+dist[2], obj[4], obj[5], obj[6]];
				obj = objects[pData[playerid].currentObj];
			}
			sendPlayerMessage(playerid, "Object duplicated "+cmd[3]+" times [0x"+format("%X", obj[0])+"] (first #"+cmd[1]+" / last #"+pData[playerid].currentObj+")", cOrange);
			return 1;
		break;
			
		case "od":
			deleteObject(pData[playerid].currentObj);
			delete objects[pData[playerid].currentObj];
			pData[playerid].currentObj = -1;
			return 1;
		break;
			
		case "os":
			pData[playerid].currentObj = cmd[1].tointeger();
			return 1;
		break;
		
		case "osearch":
			local name = command.slice(9).tolower();
			foreach(i,val in objList) {
				if(val[1].tolower().find(name) != null) {
					sendPlayerMessage(playerid, i+" - "+val[1]+" [0x"+format("%X", val[0])+"]", cOrange);
				}
			}
			return 1;
		break;
			
		case "ox":
			local pos = getObjectCoordinates(pData[playerid].currentObj);
			pos[0] += cmd[1].tofloat();
			objects[pData[playerid].currentObj][1] = pos[0];
			setObjectCoordinates(pData[playerid].currentObj, pos[0], pos[1], pos[2]);
			return 1;
		break;
			
		case "oy":
			local pos = getObjectCoordinates(pData[playerid].currentObj);
			pos[1] += cmd[1].tofloat();
			objects[pData[playerid].currentObj][2] = pos[1];
			setObjectCoordinates(pData[playerid].currentObj, pos[0], pos[1], pos[2]);
			return 1;
		break;
			
		case "oz":
			local pos = getObjectCoordinates(pData[playerid].currentObj);
			pos[2] += cmd[1].tofloat();
			objects[pData[playerid].currentObj][3] = pos[2];
			setObjectCoordinates(pData[playerid].currentObj, pos[0], pos[1], pos[2]);
			return 1;
		break;
			
		case "orx":
			local pos = getObjectRotation(pData[playerid].currentObj);
			pos[0] += cmd[1].tofloat();
			pData[playerid].currentObj = setObjectRotation(pData[playerid].currentObj, pos[0], pos[1], pos[2]);
			return 1;
		break;
			
		case "ory":
			local pos = getObjectRotation(pData[playerid].currentObj);
			pos[1] += cmd[1].tofloat();
			pData[playerid].currentObj = setObjectRotation(pData[playerid].currentObj, pos[0], pos[1], pos[2]);
			return 1;
		break;
			
		case "orz":
			local pos = getObjectRotation(pData[playerid].currentObj);
			pos[2] += cmd[1].tofloat();
			pData[playerid].currentObj = setObjectRotation(pData[playerid].currentObj, pos[0], pos[1], pos[2]);
			return 1;
		break;
			
		case "osave":
			local filename = "scripts/"+cmd[1].tostring()+".txt";
			local fp = file(filename, "a+"); // create file if not exist
			fp = file(filename, "w");
			foreach(i,val in objects) {
				local str = "createObject(0x"+format("%X", val[0])+", "+format("%f", val[1])+", "+format("%f", val[2])+", "+format("%f", val[3])+", "+format("%f", val[4])+", "+format("%f", val[5])+", "+format("%f", val[6])+");\n";
				foreach(char in str) {
					fp.writen(char, 'c');
				}
			}
			sendPlayerMessage(playerid, "Objects saved to '"+filename+"'", cOrange);
			return 1;
		break;
		
		case "oload":
			local filename = "scripts/"+cmd[1].tostring()+".txt";
			local str = "";
			local fp = file(filename, "r+");
			while(!fp.eos()) {
				str += fp.readn('c').tochar();
			}
			str = split(str, "\n");
			foreach(obj in str) {
				obj = obj.slice(13, obj.len()-2);
				obj = split(obj, ", ");
				pData[playerid].currentObj = createObject(obj[0].tointeger(), obj[1].tofloat(), obj[2].tofloat(), obj[3].tofloat(), obj[4].tofloat(), obj[5].tofloat(), obj[6].tofloat());
				objects[pData[playerid].currentObj] <- [obj[0].tointeger(), obj[1].tofloat(), obj[2].tofloat(), obj[3].tofloat(), obj[4].tofloat(), obj[5].tofloat(), obj[6].tofloat()];
			}
			sendPlayerMessage(playerid, "Object loaded from '"+filename+"'", cOrange);
			return 1;
		break;
		
		case "oclear":
			foreach(i,val in objects) {
				deleteObject(i);
			}
			objects = {};
			sendPlayerMessage(playerid, "All objects has been deleted.", cOrange);
			return 1;
		break;
	}
	return 0;
}
addEvent("playerCommand", onPlayerCommand);

function setObjectData(playerid, data) {
	data[0] = objects[pData[playerid].currentObj][0];
	objects[pData[playerid].currentObj] = data;
	setObjectCoordinates(pData[playerid].currentObj, data[1], data[2], data[3]);
	pData[playerid].currentObj = setObjectRotation(pData[playerid].currentObj, data[4], data[5], data[6]);
}
addEvent("setObjectData", setObjectData);

function moveObject(playerid, key) {
	if(!pData[playerid].keys) return 0;
	local cmd = "";
	local sign = "";
	switch(key) {
		case "w": case "s":
			cmd = "x";
		break;
		
		case "a": case "d":
			cmd = "y";
		break;
		
		case "arrow_up": case "arrow_down":
			cmd = "z";
		break;
	}
	if(key == "s" || key == "a" || key == "arrow_down") {
		sign = "-";
	}
	if(pData[playerid].keysRotation) {
		cmd = "r"+cmd;
	}
	onPlayerCommand(playerid, "/o"+cmd+" "+sign+pData[playerid].keysDistance.tostring());
}
addEvent("moveObject", moveObject);

function startMovingObject(playerid, key) {
	if(!pData[playerid].keys) return 0;
	stopMovingObject(playerid);
	pData[playerid].moveTimer = timer(moveObject, 100, -1, playerid, key);
}
addEvent("startMovingObject", startMovingObject);

function stopMovingObject(playerid) {
	if(pData[playerid].moveTimer != null) {
		if(pData[playerid].moveTimer.isActive()) {
			pData[playerid].moveTimer.kill();
			pData[playerid].moveTimer = null;
		}
	}
}
addEvent("stopMovingObject", stopMovingObject);

function toggleObjectRotation(playerid) {
	if(!pData[playerid].keys) return 0;
	pData[playerid].keysRotation = !pData[playerid].keysRotation;
	sendPlayerMessage(playerid, (pData[playerid].keysRotation ? "Rotation enabled." : "Rotation disabled."), cOrange);
}
addEvent("toggleObjectRotation", toggleObjectRotation);

function getCoordinatesInFrontOfPlayer(playerid, distance) {
	local pos, rotation;
	if(isPlayerInAnyVehicle(playerid)) {
		pos = getVehicleCoordinates(getPlayerVehicleId(playerid));
		rotation = getVehicleRotation(getPlayerVehicleId(playerid))[2];
	} else {
		pos = getPlayerCoordinates(playerid);
		rotation = getPlayerHeading(playerid);
	}
	pos[0] += (distance * sin(-(rotation*3.1415/180.0)));
	pos[1] += (distance * cos(-(rotation*3.1415/180.0)));
	return [pos[0], pos[1], pos[2], rotation];
}

// These functions do not exist so I had to find another way.
function getObjectRotation(objID) {
	return [objects[objID][4], objects[objID][5], objects[objID][6]];
}

function setObjectRotation(objID, rx, ry, rz) {
	local oldObj = objects[objID];
	objects[objID] = null;
	deleteObject(objID);
	local objID = createObject(oldObj[0], oldObj[1], oldObj[2], oldObj[3], rx, ry, rz);
	objects[objID] <- [oldObj[0], oldObj[1], oldObj[2], oldObj[3], rx, ry, rz];
	return objID;
}

function generateLoopEvent(playerid, objID, pieces, offset, radi, rotaxis, loops) {
	local pos = getObjectCoordinates(objID);
	local r = getObjectRotation(objID);
	pos[2] += radi;
	local rota = 0.0;
	switch(rotaxis) {
		case "-y": rota = 0.0; pos[1] -= offset / 2.0; break;
		case "y": rota = 180.0; pos[1] += offset / 2.0; break;
		case "-x": rota = 90.0; pos[0] -= offset / 2.0; break;
		case "x": rota = 270.0; pos[0] += offset / 2.0; break;
	}
	generateLoop(playerid, objects[objID][0], pos[0], pos[1], pos[2], pieces, offset, radi, r[0], r[1], r[2], rotaxis, loops, r[2]+rota);
}
addEvent("generateLoopEvent", generateLoopEvent);

function undoLoop(playerid) {
	foreach(i, val in pData[playerid].generatedObjects) {
		deleteObject(val);
		delete objects[val];
	}
	pData[playerid].currentObj = -1;
	pData[playerid].generatedObjects = {};
}
addEvent("undoLoop", undoLoop);

// converted from MTA, unknown author
function generateLoop(playerid, model, x, y, z, pieces, offset, radi, rx, ry, rz, rotaxis, loops, rota) {
	local angle, newi, newrotx, newroty;
	local spiralp = atan((offset/2)/(2*radi))/loops;
	local weight, radians, newx, newy, newz;
	newi = -1;
	rota = rota*(3.1415/180);
	pData[playerid].generatedObjects = {};
	for(local i = 0; i < pieces; i++) {
		weight = 1-(1/(pieces/2))*abs((pieces/2)-i);
		radians = (i.tofloat()/pieces.tofloat())*(2*3.1415)*loops;
		newx = x + radi*sin(radians)*cos(rota)+(offset/2)*cos(radians/(2*loops))*-sin(rota);
		newy = y +(offset/2)*cos(radians/(2*loops))*cos(rota)+radi*sin(radians)*sin(rota);
		newz = z + radi*-cos(radians);
		angle = (((360/pieces)* loops )* newi);
		if(angle <= 359.9999999999999999999999999) {
			newi = newi + 1;
		}
		angle = (((360/pieces)* loops )* newi);
		if(angle >= 360) {
			newi = -1;
			angle = (((360/pieces)* loops )* newi);
		}
		if(rotaxis == "x") {
			newrotx = -angle + rx;
			newroty = ry;
		} else if(rotaxis == "-x") {
			newrotx = angle + rx;
			newroty = ry;
		} else if(rotaxis == "y") {
			newrotx = rx;
			newroty = angle + ry;
		} else if(rotaxis == "-y") {
			newrotx = rx;
			newroty = -angle + ry;
		}
		pData[playerid].currentObj = createObject(model, newx, newy, newz, newrotx.tofloat(), newroty.tofloat(), rz.tofloat());
		objects[pData[playerid].currentObj] <- [model, newx, newy, newz, newrotx.tofloat(), newroty.tofloat(), rz.tofloat()];
		pData[playerid].generatedObjects[i] <- pData[playerid].currentObj;
		//log(model+", "+newx+", "+newy+", "+newz+", "+newrotx.tofloat()+", "+newroty.tofloat()+", "+rz.tofloat());
	}
}

function updateMagicCarpet(playerid) {
	if(pData[playerid].magicCarpetObjID != -1) {
		local pos = (isPlayerInAnyVehicle(playerid) ? getVehicleCoordinates(getPlayerVehicleId(playerid)) : getPlayerCoordinates(playerid));
		setCarpetPosition(playerid, pos[0], pos[1], pos[2]);
	}
}

function setCarpetPosition(playerid, x, y, z) {
	setObjectCoordinates(pData[playerid].magicCarpetObjID, x, y, (z - (isPlayerInAnyVehicle(playerid) ? 0.548306 /* faggio */ : 1.050048)));
}

function moveMagicCarpet(playerid, dir) {
	if(pData[playerid].magicCarpetObjID != -1) {
		local pos = (isPlayerInAnyVehicle(playerid) ? getVehicleCoordinates(getPlayerVehicleId(playerid)) : getPlayerCoordinates(playerid));
		pos[2] += dir*1.5;
		setCarpetPosition(playerid, pos[0], pos[1], pos[2]);
		if(isPlayerInAnyVehicle(playerid)) {
			setVehicleCoordinates(getPlayerVehicleId(playerid), pos[0], pos[1], pos[2]);
		} else {
			setPlayerCoordinates(playerid, pos[0], pos[1], pos[2]);
		}
	}
}
addEvent("moveMagicCarpet", moveMagicCarpet);