﻿local Alterac = DBM:NewBossMod("Alterac", DBM_ALTERAC, DBM_BGMOD_LANG["AV_DESCRIPTION"], DBM_OTHER, "Battlegrounds", 1);

Alterac.Version = "2.0";
Alterac.Author = "LeoLeal, Nitram, Tandanu";
Alterac.ExtraGUITab	= "BC Battlegrounds";

Alterac:RegisterEvents(
	"CHAT_MSG_MONSTER_YELL",
	"CHAT_MSG_BG_SYSTEM_ALLIANCE",
	"CHAT_MSG_BG_SYSTEM_HORDE",
	"CHAT_MSG_BG_SYSTEM_NEUTRAL",
	"GOSSIP_SHOW",
	"QUEST_PROGRESS",
	"QUEST_COMPLETE"
);


Alterac.DropdownMenu = { --I don't use :AddOption() here, because I want to use the battleground boss mod's options table
	{
		variable = "DBM.AddOns.Battlegrounds.Options.ShowInviteTimer", 
		text = DBM_BGMOD_LANG.SHOW_INV_TIMER, 
		func = function() DBM.AddOns.Battlegrounds.Options.ShowInviteTimer = not DBM.AddOns.Battlegrounds.Options.ShowInviteTimer; end, 
	},
	
	{
		variable = "DBM.AddOns.Battlegrounds.Options.ColorByClass", 
		text = DBM_BGMOD_LANG.COLOR_BY_CLASS, 
		func = function() DBM.AddOns.Battlegrounds.Options.ColorByClass = not DBM.AddOns.Battlegrounds.Options.ColorByClass; end, 
	},
};
Alterac:AddOption("AutoTurnIn", true, DBM_BGMOD_LANG.AV_TURNININFO);

function Alterac:GetNumItems(id)
	local counter = 0;
	for bag = 0,  4 do
		for slot = 1,  GetContainerNumSlots(bag) do
			local itemLink = GetContainerItemLink(bag, slot);
			local _, _, itemID = string.find(itemLink or "", "(%d+)") -- first number is the item's ID
			if tonumber(itemID) == tonumber(id) then
				local _, itemCount = GetContainerItemInfo(bag, slot);
				counter = counter + (itemCount or 1);
			end
		end
	end
	return counter;
end

function Alterac:OnEvent()
	if (event == "GOSSIP_SHOW" or event=="QUEST_PROGRESS") and GetRealZoneText() == DBM_ALTERAC and self.Options.AutoTurnIn then
		local target = UnitName("target");
		
		if target == DBM_BGMOD_LANG.AV_NPC.SMITHREGZAR or target == DBM_BGMOD_LANG.AV_NPC.MURGOTDEEPFORGE then
			local Upgrade = GetGossipOptions();
			if string.find(string.lower(Upgrade or ""), DBM_BGMOD_LANG.UPGRADETROOPS) then
				SelectGossipOption(1);
			elseif self:GetNumItems(17422) >= 20 then -- Armor Scraps
				SelectGossipAvailableQuest(1);
			end
			
		elseif target == DBM_BGMOD_LANG.AV_NPC.PRIMALISTTHURLOGA then
			local numItems = self:GetNumItems(17306); -- Stormpike Soldier's Blood
			if numItems >= 5 then
				SelectGossipAvailableQuest(2);
			elseif numItems > 0 then
				SelectGossipAvailableQuest(1);
			end
			
		elseif target == DBM_BGMOD_LANG.AV_NPC.ARCHDRUIDRENFERAL then
			local numItems = self:GetNumItems(17423); -- Storm Crystal
			if numItems >= 5 then
				SelectGossipAvailableQuest(2);
			elseif numItems > 0 then
				SelectGossipAvailableQuest(1);
			end
			
		elseif target == DBM_BGMOD_LANG.AV_NPC.STORMPIKERAMRIDERCOMMANDER then
			if self:GetNumItems(17643) > 0 then -- Frostwolf Hide
				SelectGossipAvailableQuest(1);
			end
			
		elseif target == DBM_BGMOD_LANG.AV_NPC.FROSTWOLFWOLFRIDERCOMMANDER then
			if self:GetNumItems(17642) > 0 then -- Alterac Ram Hide
				SelectGossipAvailableQuest(1);
			end
		end
		
		if event == "QUEST_PROGRESS" then
			if target == DBM_BGMOD_LANG.AV_NPC.WINGCOMMANDERJEZTOR and self:GetNumItems(17327) == 0 then -- Stormpike Lieutenant's Flesh
				return;
			elseif target == DBM_BGMOD_LANG.AV_NPC.WINGCOMMANDERGUSE and self:GetNumItems(17326) == 0 then -- Stormpike Soldier's Flesh
				return;
			elseif target == DBM_BGMOD_LANG.AV_NPC.WINGCOMMANDERMULVERICK and self:GetNumItems(17328) == 0 then -- Stormpike Commander's Flesh
				return;
			elseif target == DBM_BGMOD_LANG.AV_NPC.WINGCOMMANDERVIPORE and self:GetNumItems(17503) == 0 then -- Frostwolf Lieutenant's Medal
				return;
			elseif target == DBM_BGMOD_LANG.AV_NPC.WINDCOMMANDERSLIDORE and self:GetNumItems(17502) == 0 then -- Frostwolf Soldier's Medal
				return;
			elseif target == DBM_BGMOD_LANG.AV_NPC.WINGCOMMANDERICHMAN and self:GetNumItems(17504) == 0 then -- Frostwolf Commander's Medal
				return;
			else			
				CompleteQuest();
			end
		end
		
	elseif event == "QUEST_COMPLETE" and GetRealZoneText() == DBM_ALTERAC and self.Options.AutoTurnIn then
		local target = UnitName("target");
		for index, value in pairs(DBM_BGMOD_LANG.AV_NPC) do
			if (target == value) then
				GetQuestReward(0);
			end
		end
		
	elseif event == "CHAT_MSG_BG_SYSTEM_NEUTRAL" then --"game starts in.." timers
		if arg1 == DBM_BGMOD_LANG.AV_START60SEC then
			self:StartStatusBarTimer(62, "Begins");
		elseif arg1 == DBM_BGMOD_LANG.AV_START30SEC then		
			if not self:GetStatusBarTimerTimeLeft("Begins") then
				self:StartStatusBarTimer(62, "Begins");
			end
			self:UpdateStatusBarTimer("Begins", 31, 62);
		end
		
	elseif event == "CHAT_MSG_BG_SYSTEM_ALLIANCE" then
		if string.find(string.lower(arg1), string.lower(DBM_BGMOD_EN_TARGET_AV[8])) then -- first Snowfall capture (Alliance)
			self:EndStatusBarTimer("Horde: "..DBM_BGMOD_EN_TARGET_AV[8]);
			self:StartStatusBarTimer(303,  "Alliance: "..DBM_BGMOD_EN_TARGET_AV[8], "Interface\\Icons\\Spell_Shadow_AnimateDead", nil, nil, 0, 0, 1);
		end
		
	elseif event == "CHAT_MSG_BG_SYSTEM_HORDE" then
		if string.find(string.lower(arg1), string.lower(DBM_BGMOD_EN_TARGET_AV[8])) then -- first Snowfall capture (Horde)
			self:EndStatusBarTimer("Alliance: "..DBM_BGMOD_EN_TARGET_AV[8]);
			self:StartStatusBarTimer(303, "Horde: "..DBM_BGMOD_EN_TARGET_AV[8], "Interface\\Icons\\Spell_Shadow_AnimateDead", nil, nil, 1, 0, 0);
		end
		
	elseif event == "CHAT_MSG_MONSTER_YELL" then
	
		--zhCN translations...WTF
		if string.find(arg1, "西霜狼哨塔被部落占领了") then
			DBM.EndStatusBarTimer("Alliance: 西侧霜狼哨塔", true);
			DBM.Announce(string.format(DBM_BGMOD_LANG.HORDE_TAKE_ANNOUNCE, "西侧霜狼哨塔"));
			local oldFlashColor = DBM.Options.FlashColor;
			DBM.Options.FlashColor = "red";
			DBM.AddSpecialWarning("", false, true);
			DBM.Options.FlashColor = oldFlashColor;
		elseif string.find(arg1, "东霜狼哨塔被部落占领了") then
			DBM.EndStatusBarTimer("Alliance: 东侧霜狼哨塔", true);
			DBM.Announce(string.format(DBM_BGMOD_LANG.HORDE_TAKE_ANNOUNCE, "东侧霜狼哨塔"));
			local oldFlashColor = DBM.Options.FlashColor;
			DBM.Options.FlashColor = "red";
			DBM.AddSpecialWarning("", false, true);
			DBM.Options.FlashColor = oldFlashColor;
		elseif string.find(arg1, "西侧防御塔点被部落占领了") then
			DBM.EndStatusBarTimer("Alliance: 哨塔高地", true);
			DBM.Announce(string.format(DBM_BGMOD_LANG.HORDE_TAKE_ANNOUNCE, "哨塔高地"));
			local oldFlashColor = DBM.Options.FlashColor;
			DBM.Options.FlashColor = "red";
			DBM.AddSpecialWarning("", false, true);
			DBM.Options.FlashColor = oldFlashColor;
		elseif string.find(arg1, "石炉墓地受到攻击！如果我们不尽快采取措施的话，部落会([^%s]+)它的！") then
			self:EndStatusBarTimer("Alliance: 石炉墓地");
			self:StartStatusBarTimer(303,  "Horde: 石炉墓地", "Interface\\Icons\\Spell_Shadow_AnimateDead", true, nil, 1, 0, 0);
		elseif string.find(arg1, "石炉墓地受到攻击！如果我们不尽快采取措施的话，联盟会([^%s]+)它的！") then
			self:EndStatusBarTimer("Horde: 石炉墓地");
			self:StartStatusBarTimer(303,  "Alliance: 石炉墓地", "Interface\\Icons\\Spell_Shadow_AnimateDead", true, nil, 0, 0, 1);
		elseif string.find(arg1, "冰翼工事被联盟占领了！") then
			DBM.EndStatusBarTimer("Horde: 冰翼碉堡", true);
			DBM.Announce(string.format(DBM_BGMOD_LANG.ALLI_TAKE_ANNOUNCE, "冰翼碉堡"));
			local oldFlashColor = DBM.Options.FlashColor;
			DBM.Options.FlashColor = "blue";
			DBM.AddSpecialWarning("", false, true);
			DBM.Options.FlashColor = oldFlashColor;
		end
		-------------------------------------------------

		for index, value in ipairs(DBM_BGMOD_LANG.AV_TARGETS) do
			if string.find(string.lower(arg1), string.lower(value)) then
				if string.find(arg1, DBM_BGMOD_LANG.AV_UNDERATTACK) then
					local icon;
					if DBM_BGMOD_LANG.AV_TARGET_TYPE and DBM_BGMOD_LANG.AV_TARGET_TYPE[index] then
						if DBM_BGMOD_LANG.AV_TARGET_TYPE[index] == "tower" then
							if string.find(arg1, DBM_BGMOD_LANG.HORDE) then
								icon = "Interface\\AddOns\\DBM_API\\Textures\\GuardTower";
							elseif string.find(arg1, DBM_BGMOD_LANG.ALLIANCE) then
								icon = "Interface\\AddOns\\DBM_API\\Textures\\OrcTower"; --orc tower, because the alliance captures horde towers, so the bar is for a horde tower if the alliance captured a tower!
							end
						elseif DBM_BGMOD_LANG.AV_TARGET_TYPE[index] == "graveyard" then								
							icon = "Interface\\Icons\\Spell_Shadow_AnimateDead";
						end
					end
					
					if string.find(arg1, DBM_BGMOD_LANG.HORDE) then 
						self:EndStatusBarTimer("Alliance: "..DBM_BGMOD_EN_TARGET_AV[index]);
						self:StartStatusBarTimer(303,  "Horde: "..DBM_BGMOD_EN_TARGET_AV[index], icon or "Interface\\Icons\\INV_BannerPVP_01.blp", nil, nil, 1, 0, 0);
					elseif string.find(arg1, DBM_BGMOD_LANG.ALLIANCE) then
						self:EndStatusBarTimer("Horde: "..DBM_BGMOD_EN_TARGET_AV[index]);
						self:StartStatusBarTimer(303,  "Alliance: "..DBM_BGMOD_EN_TARGET_AV[index], icon or "Interface\\Icons\\INV_BannerPVP_02.blp", nil, nil, 0, 0, 1);
					end
					
				elseif string.find(arg1, DBM_BGMOD_LANG.AV_WASDESTROYED) or string.find(arg1, DBM_BGMOD_LANG.AV_WASTAKENBY) then
					
					local oldFlashColor = DBM.Options.FlashColor;
					if string.find(arg1, DBM_BGMOD_LANG.ALLIANCE) then
						self:Announce(string.format(DBM_BGMOD_LANG.ALLI_TAKE_ANNOUNCE, value));						
						DBM.Options.FlashColor = "blue";
					elseif string.find(arg1, DBM_BGMOD_LANG.HORDE) then
						self:Announce(string.format(DBM_BGMOD_LANG.HORDE_TAKE_ANNOUNCE, value));
						DBM.Options.FlashColor = "red";
					end
					self:AddSpecialWarning("", true);
					DBM.Options.FlashColor = oldFlashColor;
					
					self:EndStatusBarTimer("Alliance: "..DBM_BGMOD_EN_TARGET_AV[index], true);
					self:EndStatusBarTimer("Horde: "..DBM_BGMOD_EN_TARGET_AV[index], true);
				end
			end
		end
		
		if string.find(string.lower(arg1), string.lower(DBM_BGMOD_LANG.AV_IVUS)) then -- Forest and Ice Lord
			self:StartStatusBarTimer(603,  "Ivus spawn", "Interface\\Icons\\INV_BannerPVP_02.blp");
		elseif string.find(string.lower(arg1), string.lower(DBM_BGMOD_LANG.AV_ICEY)) then
			self:StartStatusBarTimer(603,  "Ice spawn", "Interface\\Icons\\INV_BannerPVP_01.blp");
		end
	end
end